package org.gcube.data.analysis.tabulardata.expression.leaf;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;

import org.gcube.data.analysis.tabulardata.expression.LeafExpression;
import org.gcube.data.analysis.tabulardata.model.column.ColumnReference;

@XmlRootElement
@XmlAccessorType(XmlAccessType.FIELD)
public class IsNull extends LeafExpression {
	
	private ColumnReference columnReference;
	
	@SuppressWarnings("unused")
	private IsNull(){}

	public IsNull(ColumnReference columnReference) {
		super();
		this.columnReference = columnReference;
	}

	public ColumnReference getColumnReference() {
		return columnReference;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((columnReference == null) ? 0 : columnReference.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		IsNull other = (IsNull) obj;
		if (columnReference == null) {
			if (other.columnReference != null)
				return false;
		} else if (!columnReference.equals(other.columnReference))
			return false;
		return true;
	}
	
	

}
