package org.gcube.data.analysis.tabulardata.model.metadata.common;

import java.util.List;
import java.util.Locale;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

import org.gcube.data.analysis.tabulardata.model.metadata.column.ColumnMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.table.TableMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement(name = "DescriptionsMetadata")
public class DescriptionsMetadata implements TableMetadata, ColumnMetadata , LocalizedTextHolder {

	@XmlTransient
	private static Logger log = LoggerFactory.getLogger(DescriptionsMetadata.class);

	/**
	 * 
	 */
	private static final long serialVersionUID = 3974092398276246215L;

	private LocalizedTextHolder delegate = new MutableLocalizedTextHolder();

	@XmlElementWrapper(name="Descriptions")
	@XmlElement(name="Description")
	public List<LocalizedText> getTexts() {
		return delegate.getTexts();
	}

	public void setTexts(List<LocalizedText> texts) {
		delegate.setTexts(texts);
	}

	public void addText(LocalizedText text) {
		delegate.addText(text);
	}

	public void removeText(LocalizedText text) {
		delegate.removeText(text);
	}

	public boolean hasTextWithLocale(Locale locale) {
		return delegate.hasTextWithLocale(locale);
	}

	public LocalizedText getTextWithLocale(Locale locale) {
		return delegate.getTextWithLocale(locale);
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((delegate == null) ? 0 : delegate.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		DescriptionsMetadata other = (DescriptionsMetadata) obj;
		if (delegate == null) {
			if (other.delegate != null)
				return false;
		} else if (!delegate.equals(other.delegate))
			return false;
		return true;
	}

	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("DescriptionsMetadata [descriptions=");
		builder.append(getTexts());
		builder.append("]");
		return builder.toString();
	}

	@Override
	public boolean isInheritable() {
		return true;
	}

	
	
}


