/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.expression.composite.arithmetic;

import javax.xml.bind.annotation.XmlRootElement;
import org.gcube.data.analysis.tabulardata.expression.Expression;
import org.gcube.data.analysis.tabulardata.expression.MalformedExpressionException;
import org.gcube.data.analysis.tabulardata.expression.Operator;
import org.gcube.data.analysis.tabulardata.expression.composite.BinaryExpression;
import org.gcube.data.analysis.tabulardata.model.datatype.DataType;
import org.gcube.data.analysis.tabulardata.model.datatype.IntegerType;
import org.gcube.data.analysis.tabulardata.model.datatype.NumericType;

@XmlRootElement
public class Modulus
extends BinaryExpression {
    private static final long serialVersionUID = 7343493694227374362L;

    private Modulus() {
    }

    public Modulus(Expression leftArgument, Expression rightArgument) {
        super(leftArgument, rightArgument);
    }

    @Override
    public Operator getOperator() {
        return Operator.DIVISION;
    }

    @Override
    public DataType getReturnedDataType() throws MalformedExpressionException {
        DataType left = this.getLeftArgument().getReturnedDataType();
        DataType right = this.getRightArgument().getReturnedDataType();
        if (!(left instanceof NumericType && right instanceof NumericType && left instanceof IntegerType && right instanceof IntegerType)) {
            throw new MalformedExpressionException("Left argument " + left + " and/or right argument " + right + " are not compatible for " + (Object)((Object)this.getOperator()));
        }
        if (left == right) {
            return left;
        }
        if (left instanceof NumericType || right instanceof NumericType) {
            return new NumericType();
        }
        throw new MalformedExpressionException("Left argument " + left + " and right argument " + right + " are not compatible for " + (Object)((Object)this.getOperator()));
    }
}

