/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.expression.leaf;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.gcube.data.analysis.tabulardata.expression.MalformedExpressionException;
import org.gcube.data.analysis.tabulardata.expression.leaf.LeafExpression;
import org.gcube.data.analysis.tabulardata.model.datatype.DataType;
import org.gcube.data.analysis.tabulardata.model.datatype.value.TDTypeValue;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement
public class Range
extends LeafExpression {
    private static final long serialVersionUID = 2332849744212415199L;
    private TDTypeValue minimum;
    private TDTypeValue maximum;

    private Range() {
    }

    public Range(TDTypeValue minimum, TDTypeValue maximum) {
        this.minimum = minimum;
        this.maximum = maximum;
    }

    public TDTypeValue getMinimum() {
        return this.minimum;
    }

    public void setMinimum(TDTypeValue minimum) {
        this.minimum = minimum;
    }

    public TDTypeValue getMaximum() {
        return this.maximum;
    }

    public void setMaximum(TDTypeValue maximum) {
        this.maximum = maximum;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.maximum == null ? 0 : this.maximum.hashCode());
        result = 31 * result + (this.minimum == null ? 0 : this.minimum.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Range other = (Range)obj;
        if (this.maximum == null ? other.maximum != null : !this.maximum.equals(other.maximum)) {
            return false;
        }
        return !(this.minimum == null ? other.minimum != null : !this.minimum.equals(other.minimum));
    }

    @Override
    public void validate() throws MalformedExpressionException {
        if (this.minimum == null) {
            throw new MalformedExpressionException("Minimum value cannot be null");
        }
        if (this.maximum == null) {
            throw new MalformedExpressionException("Maximum value cannot be null");
        }
        this.minimum.validate();
        this.maximum.validate();
        if (this.minimum.compareTo(this.maximum) > -1) {
            throw new MalformedExpressionException("Incorrect range, values : min " + this.minimum + " ,max " + this.maximum);
        }
    }

    @Override
    public DataType getReturnedDataType() throws MalformedExpressionException {
        return this.minimum.getReturnedDataType();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Range [minimum=");
        builder.append(this.minimum);
        builder.append(", maximum=");
        builder.append(this.maximum);
        builder.append("]");
        return builder.toString();
    }
}

