package org.gcube.data.analysis.tabulardata.expression.composite.text;

import java.util.ArrayList;
import java.util.List;

import org.gcube.data.analysis.tabulardata.expression.Expression;
import org.gcube.data.analysis.tabulardata.expression.ExpressionCategory;
import org.gcube.data.analysis.tabulardata.expression.composite.BinaryExpression;
import org.gcube.data.analysis.tabulardata.model.datatype.DataType;
import org.gcube.data.analysis.tabulardata.model.datatype.TextType;

public abstract class TextExpression extends BinaryExpression implements ExpressionCategory{

	/**
	 * 
	 */
	private static final long serialVersionUID = 1038382757016138183L;

	private static final List<Class<? extends DataType>> allowedTypes=new ArrayList<Class<? extends DataType>>();
	
	
	static {
		allowedTypes.add(TextType.class);
	}
	
	public TextExpression() {
		super();
	}

	public TextExpression(Expression leftArgument, Expression rightArgument) {
		super(leftArgument, rightArgument);
	}

	@Override
	public List<Class<? extends DataType>> allowedLeftDataTypes() {
				return allowedTypes;
	}
	
	@Override
	public List<Class<? extends DataType>> allowedRightDataTypes() {
		return allowedTypes;
	}
}
