package org.gcube.data.analysis.tabulardata.model.resources;

import java.net.URI;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
@XmlAccessorType(XmlAccessType.FIELD)
public class InternalURI extends Resource{

	/**
	 * 
	 */
	private static final long serialVersionUID = -3230438212164027113L;
	
	private String fileId;
	
	private URI uri;
	
	@SuppressWarnings("unused")
	private InternalURI(){}
	
	public InternalURI(URI uri){
		this.uri = uri;
	}
	
	public InternalURI(URI uri, String fileId){
		this(uri);
		this.fileId = fileId;
	}
	
	public URI getUri() {
		return uri;
	}
		
	public String getFileId() {
		return fileId;
	}

	@Override
	public String getStringValue() {
		return uri.toString();
	}

	@Override
	public Class<? extends Resource> getResourceType() {
		return this.getClass();
	}

	@Override
	public String toString() {
		return "InternalURI [fileId=" + fileId + ", uri=" + uri + "]";
	}

}
