/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.expression.composite;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import org.gcube.data.analysis.tabulardata.expression.Expression;
import org.gcube.data.analysis.tabulardata.expression.MalformedExpressionException;
import org.gcube.data.analysis.tabulardata.expression.NotEvaluableDataTypeException;
import org.gcube.data.analysis.tabulardata.expression.composite.CompositeExpression;
import org.gcube.data.analysis.tabulardata.expression.leaf.LeafExpression;
import org.gcube.data.analysis.tabulardata.model.datatype.BooleanType;
import org.gcube.data.analysis.tabulardata.model.datatype.DataType;
import org.gcube.data.analysis.tabulardata.model.datatype.DateType;
import org.gcube.data.analysis.tabulardata.model.datatype.IntegerType;
import org.gcube.data.analysis.tabulardata.model.datatype.NumericType;
import org.gcube.data.analysis.tabulardata.model.datatype.TextType;

@XmlAccessorType(value=XmlAccessType.FIELD)
public abstract class BinaryExpression
extends CompositeExpression {
    private static final List<Class<? extends DataType>> DEFAULT_ACCEPTED_TYPES = new ArrayList<Class<? extends DataType>>();
    private static final long serialVersionUID = -1471639807654392162L;
    private Expression leftArgument = null;
    private Expression rightArgument = null;

    protected BinaryExpression() {
    }

    public BinaryExpression(Expression leftArgument, Expression rightArgument) {
        this.leftArgument = leftArgument;
        this.rightArgument = rightArgument;
    }

    public Expression getLeftArgument() {
        return this.leftArgument;
    }

    public void setLeftArgument(Expression leftArgument) {
        this.leftArgument = leftArgument;
    }

    public Expression getRightArgument() {
        return this.rightArgument;
    }

    public void setRightArgument(Expression rightArgument) {
        this.rightArgument = rightArgument;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.leftArgument == null ? 0 : this.leftArgument.hashCode());
        result = 31 * result + (this.rightArgument == null ? 0 : this.rightArgument.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BinaryExpression other = (BinaryExpression)obj;
        if (this.leftArgument == null ? other.leftArgument != null : !this.leftArgument.equals(other.leftArgument)) {
            return false;
        }
        return !(this.rightArgument == null ? other.rightArgument != null : !this.rightArgument.equals(other.rightArgument));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("BinaryExpression [");
        builder.append(this.leftArgument + " ");
        builder.append((Object)((Object)this.getOperator()) + " ");
        builder.append(this.rightArgument);
        builder.append("]");
        return builder.toString();
    }

    @Override
    public void validate() throws MalformedExpressionException {
        if (this.leftArgument == null) {
            throw new MalformedExpressionException("Left Argument cannot be null, expression : " + this);
        }
        if (this.rightArgument == null) {
            throw new MalformedExpressionException("Right Argument cannot be null, expression : " + this);
        }
        this.leftArgument.validate();
        this.rightArgument.validate();
        try {
            DataType left = this.leftArgument.getReturnedDataType();
            if (!this.allowedLeftDataTypes().contains(left.getClass())) {
                throw new MalformedExpressionException(String.format("Unexpected left argument data type %s, allowed types are %s ", left, this.allowedLeftDataTypes()));
            }
            DataType right = this.rightArgument.getReturnedDataType();
            if (!this.allowedRightDataTypes().contains(right.getClass())) {
                throw new MalformedExpressionException(String.format("Unexpected right argument data type %s, allowed types are %s ", right, this.allowedRightDataTypes()));
            }
        }
        catch (NotEvaluableDataTypeException notEvaluableDataTypeException) {
            // empty catch block
        }
    }

    public List<Class<? extends DataType>> allowedLeftDataTypes() {
        return DEFAULT_ACCEPTED_TYPES;
    }

    public List<Class<? extends DataType>> allowedRightDataTypes() {
        return DEFAULT_ACCEPTED_TYPES;
    }

    @Override
    public List<Expression> getLeavesByType(Class<? extends LeafExpression> type) {
        ArrayList<Expression> toReturn = new ArrayList<Expression>();
        if (type.isInstance(this.leftArgument)) {
            toReturn.add(this.leftArgument);
        } else {
            toReturn.addAll(this.leftArgument.getLeavesByType(type));
        }
        if (type.isInstance(this.rightArgument)) {
            toReturn.add(this.rightArgument);
        } else {
            toReturn.addAll(this.rightArgument.getLeavesByType(type));
        }
        return toReturn;
    }

    static {
        DEFAULT_ACCEPTED_TYPES.add(TextType.class);
        DEFAULT_ACCEPTED_TYPES.add(BooleanType.class);
        DEFAULT_ACCEPTED_TYPES.add(DateType.class);
        DEFAULT_ACCEPTED_TYPES.add(IntegerType.class);
        DEFAULT_ACCEPTED_TYPES.add(NumericType.class);
    }
}

