package org.gcube.data.analysis.tabulardata.query.json;

import java.util.Iterator;

import org.gcube.data.analysis.tabulardata.query.TabularQuery;
import org.gcube.data.analysis.tabulardata.query.params.Filter;
import org.gcube.data.analysis.tabulardata.query.params.Ordering;
import org.gcube.data.analysis.tabulardata.query.params.Page;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TabularJSONQueryImpl implements TabularJSONQuery {

	private Logger log = LoggerFactory.getLogger(TabularJSONQueryImpl.class);

	private TabularQuery tabularQuery;

	public TabularJSONQueryImpl(TabularQuery tabularQuery) {
		super();
		this.tabularQuery = tabularQuery;
	}

	@Override
	public TabularJSONQuery setFilter(Filter filter) {
		tabularQuery.setFilter(filter);
		return this;
	}

	@Override
	public TabularJSONQuery setOrdering(Ordering ordering) {
		tabularQuery.setOrdering(ordering);
		return this;
	}

	@Override
	public int getTotalTuples() {
		return tabularQuery.getTotalTuples();
	}

	@Override
	public String getPage(Page page) {
		Iterator<Object[]> queryResult = tabularQuery.getPage(page);
		return generateJSONFromData(queryResult);

	}

	@Override
	public String getAll() {
		Iterator<Object[]> queryResult = tabularQuery.getAll();
		return generateJSONFromData(queryResult);
	}

	private String generateJSONFromData(Iterator<Object[]> dataIterator) {
		JSONObject json = new JSONObject();
		JSONArray jsonRows = new JSONArray();
		while (dataIterator.hasNext()) {
			Object[] row = dataIterator.next();
			jsonRows.put(row);
		}
		try {
			json.put("rows", jsonRows);
		} catch (JSONException e) {
			log.error("Unable to produce JSON document.", e);
			throw new RuntimeException("Error occured with serialization of table content. Check server log.");
		}
		return json.toString();
	}

}
