package org.gcube.data.analysis.tabulardata.query.sql;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Iterator;

import org.apache.commons.dbutils.DbUtils;
import org.apache.commons.dbutils.ResultSetHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLResultSetIterator implements Iterator<Object[]> {

	Logger log = LoggerFactory.getLogger(SQLResultSetIterator.class);

	ResultSet rs;

	public SQLResultSetIterator(ResultSet rs) {
		super();
		this.rs = rs;
	}

	@Override
	public boolean hasNext() {
		try {
			if (rs.isClosed())
				return false;
			return !rs.isLast();
		} catch (SQLException e) {
			throw new RuntimeException("Unable to read query result from DB. Check server logs.");
		}
	}

	@Override
	public Object[] next() {
		ResultSetHandler<Object[]> rsh = new ObjectHandler();
		try {
			Object[] result = rsh.handle(rs);
			if (rs.isLast()) {
				DbUtils.closeQuietly(rs.getStatement());
				DbUtils.closeQuietly(rs);
			}
			return result;
		} catch (SQLException e) {
			String msg = "Unable to read from ResultSet.";
			log.error(msg, e);
			throw new RuntimeException(msg, e);
		}
	}

	@Override
	public void remove() {
		throw new UnsupportedOperationException("Remove operations is unsupported.");
	}

	class ObjectHandler implements ResultSetHandler<Object[]> {

		@Override
		public Object[] handle(ResultSet rs) throws SQLException {

			if (!rs.next()) {
				return null;
			}

			ResultSetMetaData meta = rs.getMetaData();
			int cols = meta.getColumnCount();
			Object[] result = new Object[cols];

			for (int i = 0; i < cols; i++) {
				result[i] = rs.getObject(i + 1);
			}

			return result;

		}

	}

}
