/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.clientlibrary.proxy;

import java.util.List;
import org.gcube.common.clients.Call;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.common.clients.exceptions.FaultDSL;
import org.gcube.data.analysis.tabulardata.clientlibrary.proxy.OperationManagerProxy;
import org.gcube.data.analysis.tabulardata.operation.OperationDescriptor;
import org.gcube.data.analysis.tabulardata.operation.OperationId;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.td.commons.webservice.OperationManager;
import org.gcube.data.td.commons.webservice.exception.InvalidInvocationException;
import org.gcube.data.td.commons.webservice.exception.NoSuchTabularResourceException;
import org.gcube.data.td.commons.webservice.exception.OperationNotFoundException;
import org.gcube.data.td.commons.webservice.types.ExecuteRequest;
import org.gcube.data.td.commons.webservice.types.TaskInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultOperationManagerProxy
implements OperationManagerProxy {
    private static Logger logger = LoggerFactory.getLogger(DefaultOperationManagerProxy.class);
    private final ProxyDelegate<OperationManager> delegate;

    public DefaultOperationManagerProxy(ProxyDelegate<OperationManager> config) {
        this.delegate = config;
    }

    @Override
    public List<OperationDescriptor> getCapabilities() {
        Call<OperationManager, List<OperationDescriptor>> call = new Call<OperationManager, List<OperationDescriptor>>(){

            public List<OperationDescriptor> call(OperationManager endpoint) throws Exception {
                return endpoint.getCapabilities().getOperationDescriptors();
            }
        };
        try {
            return (List)this.delegate.make((Call)call);
        }
        catch (Exception e) {
            logger.error("error calling getCapabilities", (Throwable)e);
            throw FaultDSL.again((Throwable)e).asServiceException();
        }
    }

    @Override
    public OperationDescriptor getCapabilities(final OperationId operationId) throws OperationNotFoundException {
        Call<OperationManager, OperationDescriptor> call = new Call<OperationManager, OperationDescriptor>(){

            public OperationDescriptor call(OperationManager endpoint) throws Exception {
                return endpoint.getOperationDescriptor(operationId).getDescriptor();
            }
        };
        try {
            return (OperationDescriptor)this.delegate.make((Call)call);
        }
        catch (OperationNotFoundException e) {
            logger.error("operation with id {} not found", (Object)operationId.getValue());
            throw e;
        }
        catch (Exception e) {
            logger.error("error calling getCapabilities", (Throwable)e);
            throw FaultDSL.again((Throwable)e).asServiceException();
        }
    }

    @Override
    public TaskInfo execute(final long targetTabularResourceId, final OperationInvocation ... invocations) throws NoSuchTabularResourceException, InvalidInvocationException, OperationNotFoundException {
        Call<OperationManager, TaskInfo> call = new Call<OperationManager, TaskInfo>(){

            public TaskInfo call(OperationManager endpoint) throws Exception {
                return endpoint.execute(new ExecuteRequest(targetTabularResourceId, invocations));
            }
        };
        try {
            return (TaskInfo)this.delegate.make((Call)call);
        }
        catch (NoSuchTabularResourceException e) {
            logger.error("no tabular resource found with id " + targetTabularResourceId, (Throwable)e);
            throw e;
        }
        catch (InvalidInvocationException e) {
            logger.error("invalid invocation", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.error("service error", (Throwable)e);
            throw FaultDSL.again((Throwable)e).asServiceException();
        }
    }
}

