package org.gcube.data.analysis.tabulardata.api.importer;

import java.util.Map;

import org.gcube.data.analysis.tabulardata.api.NamedWorker;
import org.gcube.data.analysis.tabulardata.api.OperationMonitor;

public interface RemoteImporter extends NamedWorker {
	
	/**
	 * 
	 * @param metadata the metadata associated with the specific importer
	 * @param parserDataAsJson the key-value data for parsing purpose
	 * @param url the url pointing to the resource to import
	 * @param opMonitor a monitor object
	 * @return
	 * @throws InputNotValidException
	 */
	public ImportResult importData(String url, Map<String, String> parameters, OperationMonitor opMonitor) throws IllegalArgumentException;
			
}
