/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.map.ext;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.JsonToken;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.deser.StdDeserializer;
import org.codehaus.jackson.map.deser.StdScalarDeserializer;
import org.codehaus.jackson.map.util.Provider;
import org.joda.time.DateMidnight;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JodaDeserializers
implements Provider<StdDeserializer<?>> {
    @Override
    public Collection<StdDeserializer<?>> provide() {
        return Arrays.asList(new DateTimeDeserializer(), new LocalDateDeserializer(), new LocalDateTimeDeserializer(), new DateMidnightDeserializer());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DateMidnightDeserializer
    extends JodaDeserializer<DateMidnight> {
        public DateMidnightDeserializer() {
            super(DateMidnight.class);
        }

        @Override
        public DateMidnight deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            switch (jp.getCurrentToken()) {
                case VALUE_NUMBER_INT: {
                    return new DateMidnight(jp.getLongValue());
                }
                case VALUE_STRING: {
                    return this.parseLocal(jp).toDateMidnight();
                }
                case START_ARRAY: {
                    jp.nextToken();
                    int year = jp.getIntValue();
                    jp.nextToken();
                    int month = jp.getIntValue();
                    jp.nextToken();
                    int day = jp.getIntValue();
                    if (jp.nextToken() != JsonToken.END_ARRAY) {
                        ctxt.wrongTokenException(jp, JsonToken.START_ARRAY, "expected END_ARRAY after DateMidnight ints");
                    }
                    return new DateMidnight(year, month, day);
                }
            }
            ctxt.wrongTokenException(jp, JsonToken.START_ARRAY, "expected JSON Array, Number or String");
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LocalDateTimeDeserializer
    extends JodaDeserializer<LocalDateTime> {
        public LocalDateTimeDeserializer() {
            super(LocalDateTime.class);
        }

        @Override
        public LocalDateTime deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            switch (jp.getCurrentToken()) {
                case VALUE_NUMBER_INT: {
                    return new LocalDateTime(jp.getLongValue());
                }
                case VALUE_STRING: {
                    return this.parseLocal(jp).toLocalDateTime();
                }
                case START_ARRAY: {
                    jp.nextToken();
                    int year = jp.getIntValue();
                    jp.nextToken();
                    int month = jp.getIntValue();
                    jp.nextToken();
                    int day = jp.getIntValue();
                    jp.nextToken();
                    int hour = jp.getIntValue();
                    jp.nextToken();
                    int minute = jp.getIntValue();
                    jp.nextToken();
                    int second = jp.getIntValue();
                    int millisecond = 0;
                    if (jp.nextToken() != JsonToken.END_ARRAY) {
                        millisecond = jp.getIntValue();
                        jp.nextToken();
                    }
                    if (jp.getCurrentToken() != JsonToken.END_ARRAY) {
                        ctxt.wrongTokenException(jp, JsonToken.START_ARRAY, "expected END_ARRAY after LocalDateTime ints");
                    }
                    return new LocalDateTime(year, month, day, hour, minute, second, millisecond);
                }
            }
            ctxt.wrongTokenException(jp, JsonToken.START_ARRAY, "expected JSON Array or Number");
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LocalDateDeserializer
    extends JodaDeserializer<LocalDate> {
        public LocalDateDeserializer() {
            super(LocalDate.class);
        }

        @Override
        public LocalDate deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            switch (jp.getCurrentToken()) {
                case VALUE_NUMBER_INT: {
                    return new LocalDate(jp.getLongValue());
                }
                case VALUE_STRING: {
                    return this.parseLocal(jp).toLocalDate();
                }
                case START_ARRAY: {
                    jp.nextToken();
                    int year = jp.getIntValue();
                    jp.nextToken();
                    int month = jp.getIntValue();
                    jp.nextToken();
                    int day = jp.getIntValue();
                    if (jp.nextToken() != JsonToken.END_ARRAY) {
                        ctxt.wrongTokenException(jp, JsonToken.START_ARRAY, "expected END_ARRAY after LocalDate ints");
                    }
                    return new LocalDate(year, month, day);
                }
            }
            ctxt.wrongTokenException(jp, JsonToken.START_ARRAY, "expected JSON Array or Number");
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DateTimeDeserializer
    extends JodaDeserializer<DateTime> {
        public DateTimeDeserializer() {
            super(DateTime.class);
        }

        @Override
        public DateTime deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JsonToken t = jp.getCurrentToken();
            if (t == JsonToken.VALUE_NUMBER_INT) {
                return new DateTime(jp.getLongValue(), DateTimeZone.UTC);
            }
            if (t == JsonToken.VALUE_STRING) {
                return new DateTime((Object)jp.getText().trim(), DateTimeZone.UTC);
            }
            throw ctxt.mappingException(this.getValueClass());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class JodaDeserializer<T>
    extends StdScalarDeserializer<T> {
        static final DateTimeFormatter _localDateTimeFormat = ISODateTimeFormat.localDateOptionalTimeParser();

        protected JodaDeserializer(Class<T> cls) {
            super(cls);
        }

        protected DateTime parseLocal(JsonParser jp) throws IOException, JsonProcessingException {
            return _localDateTimeFormat.parseDateTime(jp.getText());
        }
    }
}

