/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset.conv;

import java.io.IOException;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import ucar.ma2.ArrayLong;
import ucar.ma2.DataType;
import ucar.nc2.Attribute;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.dataset.CoordSysBuilder;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.util.CancelTask;

public class ModisSatellite
extends CoordSysBuilder {
    public static boolean isMine(NetcdfFile ncfile) {
        String satName = ncfile.findAttValueIgnoreCase(null, "SATNAME", null);
        if (satName == null || !satName.equalsIgnoreCase("Aqua")) {
            return false;
        }
        String instName = ncfile.findAttValueIgnoreCase(null, "INTRUMENT_NAME", null);
        return instName != null && instName.equalsIgnoreCase("modis");
    }

    public ModisSatellite() {
        this.conventionName = "ModisSatellite";
    }

    @Override
    public void augmentDataset(NetcdfDataset ds, CancelTask cancelTask) throws IOException {
        for (Variable v : ds.getVariables()) {
            this.checkIfAxis(v);
        }
        int year = ds.readAttributeInteger(null, "YEAR", -1);
        int doy = ds.readAttributeInteger(null, "DAY", -1);
        double time = ds.readAttributeDouble(null, "TIME", Double.NaN);
        if (year > 0 && doy > 0 && !Double.isNaN(time)) {
            GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
            cal.clear();
            cal.set(1, year);
            cal.set(6, doy);
            int hour = (int)time;
            cal.set(11, hour);
            time -= (double)hour;
            int minute = (int)(time *= 60.0);
            cal.set(12, minute);
            time -= (double)minute;
            cal.set(13, (int)(time *= 60.0));
            VariableDS var = new VariableDS(ds, null, null, "timeFromAtts", DataType.LONG, "", "seconds since 1970-01-01 00:00", "time generated from global attributes");
            ds.addVariable(null, var);
            ArrayLong.D0 data = new ArrayLong.D0();
            data.set(cal.getTime().getTime() / 1000L);
            var.setCachedData(data, true);
        }
        ds.finish();
    }

    private void checkIfAxis(Variable v) {
        String name = v.getName();
        if (name.equalsIgnoreCase("Longitude")) {
            v.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Lon.toString()));
        } else if (name.equalsIgnoreCase("Latitude")) {
            v.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Lat.toString()));
        }
    }
}

