/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.collection;

import java.io.IOException;
import java.util.Formatter;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.inventory.TimedCollection;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.ft.FeatureCollection;
import ucar.nc2.ft.FeatureDatasetFactoryManager;
import ucar.nc2.ft.FeatureDatasetPoint;
import ucar.nc2.ft.PointFeature;
import ucar.nc2.ft.PointFeatureCollection;
import ucar.nc2.ft.PointFeatureIterator;
import ucar.nc2.ft.StationTimeSeriesFeatureCollection;
import ucar.nc2.ft.point.PointCollectionImpl;
import ucar.nc2.ft.point.PointIteratorAbstract;
import ucar.nc2.ft.point.collection.CompositeDatasetFactory;
import ucar.nc2.units.DateRange;
import ucar.unidata.geoloc.LatLonRect;

public class CompositeStationCollectionFlattened
extends PointCollectionImpl {
    private static Logger logger = LoggerFactory.getLogger(CompositeStationCollectionFlattened.class);
    private TimedCollection stnCollections;
    private LatLonRect bbSubset;
    private List<String> stationsSubset;
    private DateRange dateRange;
    private List<VariableSimpleIF> varList;
    private boolean wantStationsubset = false;

    protected CompositeStationCollectionFlattened(String name, List<String> stations, DateRange dateRange, List<VariableSimpleIF> varList, TimedCollection stnCollections) throws IOException {
        super(name);
        this.stationsSubset = stations;
        this.dateRange = dateRange;
        this.varList = varList;
        this.stnCollections = stnCollections;
        this.wantStationsubset = stations != null && stations.size() > 0;
    }

    protected CompositeStationCollectionFlattened(String name, LatLonRect bbSubset, DateRange dateRange, TimedCollection stnCollections) throws IOException {
        super(name);
        this.bbSubset = bbSubset;
        this.dateRange = dateRange;
        this.stnCollections = stnCollections;
    }

    @Override
    public PointFeatureIterator getPointFeatureIterator(int bufferSize) throws IOException {
        PointIterator iter = new PointIterator();
        if (this.boundingBox == null || this.dateRange == null || this.npts < 0) {
            iter.setCalculateBounds(this);
        }
        return iter;
    }

    private class PointIterator
    extends PointIteratorAbstract {
        private boolean finished = false;
        private int bufferSize = -1;
        private Iterator<TimedCollection.Dataset> iter;
        private FeatureDatasetPoint currentDataset;
        private PointFeatureIterator pfIter = null;

        PointIterator() {
            this.iter = CompositeStationCollectionFlattened.this.stnCollections.getDatasets().iterator();
        }

        private PointFeatureIterator getNextIterator() throws IOException {
            if (!this.iter.hasNext()) {
                return null;
            }
            TimedCollection.Dataset td = this.iter.next();
            Formatter errlog = new Formatter();
            this.currentDataset = (FeatureDatasetPoint)FeatureDatasetFactoryManager.open(FeatureType.STATION, td.getLocation(), null, errlog);
            if (this.currentDataset == null) {
                logger.error("FeatureDatasetFactoryManager failed to open: " + td.getLocation() + " \nerrlog = " + errlog);
                return this.getNextIterator();
            }
            if (CompositeDatasetFactory.debug) {
                System.out.printf("CompositeStationCollectionFlattened.Iterator open new dataset: %s%n", td.getLocation());
            }
            List<FeatureCollection> fcList = this.currentDataset.getPointFeatureCollectionList();
            StationTimeSeriesFeatureCollection stnCollection = (StationTimeSeriesFeatureCollection)fcList.get(0);
            PointFeatureCollection pc = null;
            pc = CompositeStationCollectionFlattened.this.wantStationsubset ? stnCollection.flatten(CompositeStationCollectionFlattened.this.stationsSubset, CompositeStationCollectionFlattened.this.dateRange, CompositeStationCollectionFlattened.this.varList) : stnCollection.flatten(CompositeStationCollectionFlattened.this.bbSubset, CompositeStationCollectionFlattened.this.dateRange);
            return pc.getPointFeatureIterator(this.bufferSize);
        }

        @Override
        public boolean hasNext() throws IOException {
            if (this.pfIter == null) {
                this.pfIter = this.getNextIterator();
                if (this.pfIter == null) {
                    this.finish();
                    return false;
                }
            }
            if (!this.pfIter.hasNext()) {
                this.pfIter.finish();
                this.currentDataset.close();
                if (CompositeDatasetFactory.debug) {
                    System.out.printf("CompositeStationCollectionFlattened.Iterator close dataset: %s%n", this.currentDataset.getLocation());
                }
                this.pfIter = this.getNextIterator();
                return this.hasNext();
            }
            return true;
        }

        @Override
        public PointFeature next() throws IOException {
            return this.pfIter.next();
        }

        @Override
        public void finish() {
            if (this.finished) {
                return;
            }
            if (this.pfIter != null) {
                this.pfIter.finish();
            }
            this.finishCalcBounds();
            if (this.currentDataset != null) {
                try {
                    this.currentDataset.close();
                    if (CompositeDatasetFactory.debug) {
                        System.out.printf("CompositeStationCollectionFlattened close dataset: %s%n", this.currentDataset.getLocation());
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            this.finished = true;
        }

        @Override
        public void setBufferSize(int bytes) {
            this.bufferSize = bytes;
        }
    }
}

