/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.util.stax;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.util.stax.XMLEventUtils;

public abstract class AbstractXMLStreamReader
implements XMLStreamReader {
    public boolean hasText() {
        int event = this.getEventType();
        return event == 4 || event == 11 || event == 12 || event == 9 || event == 5 || event == 6;
    }

    public int nextTag() throws XMLStreamException {
        int eventType = this.next();
        while (eventType == 4 && this.isWhiteSpace() || eventType == 12 && this.isWhiteSpace() || eventType == 6 || eventType == 3 || eventType == 5) {
            eventType = this.next();
        }
        if (eventType != 1 && eventType != 2) {
            throw new XMLStreamException("expected start or end tag", this.getLocation());
        }
        return eventType;
    }

    public boolean isStartElement() {
        return this.getEventType() == 1;
    }

    public boolean isEndElement() {
        return this.getEventType() == 2;
    }

    public boolean isCharacters() {
        return this.getEventType() == 4;
    }

    public boolean hasName() {
        int event = this.getEventType();
        return event == 1 || event == 2;
    }

    public void require(int type, String uri, String localName) throws XMLStreamException {
        int actualType = this.getEventType();
        if (type != actualType) {
            throw new XMLStreamException("Required type " + XMLEventUtils.getEventTypeString(type) + ", actual type " + XMLEventUtils.getEventTypeString(actualType));
        }
        if (localName != null) {
            if (actualType != 1 && actualType != 2 && actualType != 9) {
                throw new XMLStreamException("Required a non-null local name, but current token not a START_ELEMENT, END_ELEMENT or ENTITY_REFERENCE (was " + XMLEventUtils.getEventTypeString(actualType) + ")");
            }
            String actualLocalName = this.getLocalName();
            if (actualLocalName != localName && !actualLocalName.equals(localName)) {
                throw new XMLStreamException("Required local name '" + localName + "'; current local name '" + actualLocalName + "'.");
            }
        }
        if (uri != null) {
            if (actualType != 1 && actualType != 2) {
                throw new XMLStreamException("Required non-null namespace URI, but current token not a START_ELEMENT or END_ELEMENT (was " + XMLEventUtils.getEventTypeString(actualType) + ")");
            }
            String actualUri = this.getNamespaceURI();
            if (uri.length() == 0) {
                if (actualUri != null && actualUri.length() > 0) {
                    throw new XMLStreamException("Required empty namespace, instead have '" + actualUri + "'.");
                }
            } else if (!uri.equals(actualUri)) {
                throw new XMLStreamException("Required namespace '" + uri + "'; have '" + actualUri + "'.");
            }
        }
    }
}

