/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools;

import java.io.BufferedReader;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.security.PrivilegedExceptionAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.StringUtils;

public class DelegationTokenFetcher {
    private static final String USAGE = "fetchdt retrieves delegation tokens (optionally over http)\nand writes them to specified file.\nUsage: fetchdt [--webservice <namenode http addr>] <output filename>";
    private final DistributedFileSystem dfs;
    private final UserGroupInformation ugi;
    private final DataOutputStream out;
    private final Configuration conf;
    private static final Log LOG = LogFactory.getLog(DelegationTokenFetcher.class);

    public static void main(final String[] args) throws Exception {
        UserGroupInformation.getCurrentUser().doAs(new PrivilegedExceptionAction<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() throws Exception {
                if (args.length == 3 && "--webservice".equals(args[0])) {
                    DelegationTokenFetcher.getDTfromRemoteIntoFile(args[1], args[2]);
                    return null;
                }
                if (args.length == 1 && "--webservice".equals(args[0])) {
                    System.out.println(DelegationTokenFetcher.USAGE);
                    return null;
                }
                if (args.length != 1 || args[0].isEmpty()) {
                    System.out.println(DelegationTokenFetcher.USAGE);
                    return null;
                }
                FilterOutputStream out = null;
                try {
                    Configuration conf = new Configuration();
                    DistributedFileSystem dfs = (DistributedFileSystem)FileSystem.get(conf);
                    out = new DataOutputStream(new FileOutputStream(args[0]));
                    UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
                    new DelegationTokenFetcher(dfs, (DataOutputStream)out, ugi, conf).go();
                    ((DataOutputStream)out).flush();
                    System.out.println("Succesfully wrote token of size " + ((DataOutputStream)out).size() + " bytes to " + args[0]);
                }
                catch (IOException ioe) {
                    System.out.println("Exception encountered:\n" + StringUtils.stringifyException(ioe));
                }
                finally {
                    if (out != null) {
                        out.close();
                    }
                }
                return null;
            }
        });
    }

    public DelegationTokenFetcher(DistributedFileSystem dfs, DataOutputStream out, UserGroupInformation ugi, Configuration conf) {
        this.checkNotNull("dfs", dfs);
        this.dfs = dfs;
        this.checkNotNull("out", out);
        this.out = out;
        this.checkNotNull("ugi", ugi);
        this.ugi = ugi;
        this.checkNotNull("conf", conf);
        this.conf = conf;
    }

    private void checkNotNull(String s, Object o) {
        if (o == null) {
            throw new IllegalArgumentException(s + " cannot be null.");
        }
    }

    public void go() throws IOException {
        String fullName = this.ugi.getUserName();
        String shortName = this.ugi.getShortUserName();
        Token<DelegationTokenIdentifier> token = this.dfs.getDelegationToken(new Text(fullName));
        URI uri = FileSystem.getDefaultUri(this.conf);
        String nnAddress = InetAddress.getByName(uri.getHost()).getHostAddress() + ":" + uri.getPort();
        token.setService(new Text(nnAddress));
        Credentials ts = new Credentials();
        ts.addToken(new Text(shortName), token);
        ts.writeTokenStorageToStream(this.out);
    }

    public static Credentials getDTfromRemote(String nnAddr, String renewer) throws IOException {
        FilterInputStream dis = null;
        try {
            StringBuffer url = new StringBuffer();
            if (renewer != null) {
                url.append(nnAddr).append("/getDelegationToken").append("?").append("renewer").append("=").append(renewer);
            } else {
                url.append(nnAddr).append("/getDelegationToken");
            }
            System.out.println("Retrieving token from: " + url);
            URL remoteURL = new URL(url.toString());
            SecurityUtil.fetchServiceTicket(remoteURL);
            URLConnection connection = remoteURL.openConnection();
            InputStream in = connection.getInputStream();
            Credentials ts = new Credentials();
            dis = new DataInputStream(in);
            ts.readFields((DataInput)((Object)dis));
            Credentials credentials = ts;
            return credentials;
        }
        catch (Exception e) {
            throw new IOException("Unable to obtain remote token", e);
        }
        finally {
            if (dis != null) {
                dis.close();
            }
        }
    }

    public static long renewDelegationToken(String nnAddr, Token<DelegationTokenIdentifier> tok) throws IOException {
        StringBuilder buf = new StringBuilder();
        buf.append(nnAddr);
        buf.append("/renewDelegationToken");
        buf.append("?");
        buf.append("token");
        buf.append("=");
        buf.append(tok.encodeToUrlString());
        BufferedReader in = null;
        try {
            URL url = new URL(buf.toString());
            SecurityUtil.fetchServiceTicket(url);
            URLConnection connection = url.openConnection();
            in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            long result = Long.parseLong(in.readLine());
            in.close();
            return result;
        }
        catch (IOException ie) {
            IOUtils.cleanup(LOG, in);
            throw ie;
        }
    }

    public static void cancelDelegationToken(String nnAddr, Token<DelegationTokenIdentifier> tok) throws IOException {
        StringBuilder buf = new StringBuilder();
        buf.append(nnAddr);
        buf.append("/cancelDelegationToken");
        buf.append("?");
        buf.append("token");
        buf.append("=");
        buf.append(tok.encodeToUrlString());
        Object in = null;
        try {
            URL url = new URL(buf.toString());
            SecurityUtil.fetchServiceTicket(url);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            if (connection.getResponseCode() != 200) {
                throw new IOException("Error cancelling token:" + connection.getResponseMessage());
            }
        }
        catch (IOException ie) {
            IOUtils.cleanup(LOG, in);
            throw ie;
        }
    }

    private static void getDTfromRemoteIntoFile(String nnAddr, String filename) throws IOException {
        Credentials ts = DelegationTokenFetcher.getDTfromRemote(nnAddr, null);
        DataOutputStream file = new DataOutputStream(new FileOutputStream(filename));
        ts.writeTokenStorageToStream(file);
        file.flush();
        System.out.println("Successfully wrote token of " + file.size() + " bytes  to " + filename);
    }

    static {
        System.setProperty("https.cipherSuites", "TLS_KRB5_WITH_3DES_EDE_CBC_SHA");
    }
}

