/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.io.File;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;

public class DiskChecker {
    private static final Log LOG = LogFactory.getLog(DiskChecker.class);

    public static boolean mkdirsWithExistsCheck(File dir) {
        if (dir.mkdir() || dir.exists()) {
            return true;
        }
        File canonDir = null;
        try {
            canonDir = dir.getCanonicalFile();
        }
        catch (IOException e) {
            return false;
        }
        String parent = canonDir.getParent();
        return parent != null && DiskChecker.mkdirsWithExistsCheck(new File(parent)) && (canonDir.mkdir() || canonDir.exists());
    }

    public static void checkDir(File dir) throws DiskErrorException {
        if (!DiskChecker.mkdirsWithExistsCheck(dir)) {
            throw new DiskErrorException("can not create directory: " + dir.toString());
        }
        if (!dir.isDirectory()) {
            throw new DiskErrorException("not a directory: " + dir.toString());
        }
        if (!dir.canRead()) {
            throw new DiskErrorException("directory is not readable: " + dir.toString());
        }
        if (!dir.canWrite()) {
            throw new DiskErrorException("directory is not writable: " + dir.toString());
        }
    }

    public static boolean mkdirsWithExistsAndPermissionCheck(LocalFileSystem localFS, Path dir, FsPermission expected) throws IOException {
        File directory = new File(dir.makeQualified(localFS).toUri().getPath());
        if (!directory.exists()) {
            boolean created = DiskChecker.mkdirsWithExistsCheck(directory);
            if (created) {
                localFS.setPermission(dir, expected);
                return true;
            }
            return false;
        }
        FsPermission actual = localFS.getFileStatus(dir).getPermission();
        if (!actual.equals(expected)) {
            LOG.warn((Object)("Incorrect permissions were set on " + dir + ", expected: " + expected + ", while actual: " + actual + ". Fixing..."));
            localFS.setPermission(dir, expected);
        }
        return true;
    }

    public static void checkDir(LocalFileSystem localFS, Path dir, FsPermission expected) throws DiskErrorException, IOException {
        if (!DiskChecker.mkdirsWithExistsAndPermissionCheck(localFS, dir, expected)) {
            throw new DiskErrorException("can not create directory: " + dir.toString());
        }
        FileStatus stat = localFS.getFileStatus(dir);
        FsPermission actual = stat.getPermission();
        if (!stat.isDir()) {
            throw new DiskErrorException("not a directory: " + dir.toString());
        }
        FsAction user = actual.getUserAction();
        if (!user.implies(FsAction.READ)) {
            throw new DiskErrorException("directory is not readable: " + dir.toString());
        }
        if (!user.implies(FsAction.WRITE)) {
            throw new DiskErrorException("directory is not writable: " + dir.toString());
        }
    }

    public static class DiskOutOfSpaceException
    extends IOException {
        public DiskOutOfSpaceException(String msg) {
            super(msg);
        }
    }

    public static class DiskErrorException
    extends IOException {
        public DiskErrorException(String msg) {
            super(msg);
        }
    }
}

