/*
 * Decompiled with CFR 0.152.
 */
package com.terradue.jcatalogue.client.internal.ahc;

import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.Cookie;
import com.ning.http.client.Realm;
import com.ning.http.client.RequestBuilder;
import com.ning.http.client.filter.IOExceptionFilter;
import com.ning.http.client.filter.ResponseFilter;
import com.ning.http.client.resumable.ResumableIOExceptionFilter;
import com.terradue.jcatalogue.client.HttpAuthScheme;
import com.terradue.jcatalogue.client.HttpMethod;
import com.terradue.jcatalogue.client.Parameter;
import com.terradue.jcatalogue.client.internal.ahc.DummyTrustManager;
import com.terradue.jcatalogue.client.internal.ahc.UmSsoAccess;
import com.terradue.jcatalogue.client.internal.ahc.UmSsoStatusResponseFilter;
import com.terradue.jcatalogue.client.internal.lang.Assertions;
import java.io.File;
import java.net.URI;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.apache.commons.ssl.KeyMaterial;

public final class HttpInvoker {
    private final Map<String, Realm> realms = new HashMap<String, Realm>();
    private final List<KeyManager> keyManagers = new ArrayList<KeyManager>();
    private final TrustManager[] trustManagers = new TrustManager[]{new DummyTrustManager()};
    private final ConcurrentMap<String, ConcurrentMap<String, Cookie>> cookiesRegistry = new ConcurrentHashMap<String, ConcurrentMap<String, Cookie>>();
    private final ConcurrentMap<String, UmSsoAccess> umSsoCredentials = new ConcurrentHashMap<String, UmSsoAccess>();
    private final AsyncHttpClient httpClient;

    public HttpInvoker() {
        SSLContext context = null;
        try {
            context = SSLContext.getInstance("TLS");
            context.init(new KeyManager[0], this.trustManagers, null);
        }
        catch (Exception e) {
            throw new IllegalStateException("Impossible to initialize SSL context", e);
        }
        int timeout = 162000000;
        this.httpClient = new AsyncHttpClient(new AsyncHttpClientConfig.Builder().setRequestTimeoutInMs(timeout).setAllowPoolingConnection(true).addIOExceptionFilter((IOExceptionFilter)new ResumableIOExceptionFilter()).setMaximumConnectionsPerHost(10).setMaximumConnectionsTotal(100).addResponseFilter((ResponseFilter)new UmSsoStatusResponseFilter(this.umSsoCredentials, this.cookiesRegistry)).setFollowRedirects(true).setMaximumNumberOfRedirects(Integer.MAX_VALUE).setSSLContext(context).build());
    }

    public <T> T invoke(HttpMethod httpMethod, URI uri, AsyncHandler<T> handler, Parameter ... parameters) {
        Assertions.checkNotNull(uri, "Input URI cannot be null", new Object[0]);
        RequestBuilder requestBuilder = new RequestBuilder(httpMethod.toString()).setUrl(uri.toString());
        Map domainCookies = (Map)this.cookiesRegistry.get(uri.getHost());
        if (domainCookies != null && !domainCookies.isEmpty()) {
            for (Cookie cookie : domainCookies.values()) {
                requestBuilder.addCookie(cookie);
            }
        }
        for (Parameter parameter : parameters) {
            if (HttpMethod.GET == httpMethod) {
                requestBuilder.addQueryParameter(parameter.getName(), parameter.getValue());
                continue;
            }
            requestBuilder.addParameter(parameter.getName(), parameter.getValue());
        }
        if (this.realms.containsKey(uri.getHost())) {
            requestBuilder.setRealm(this.realms.get(uri.getHost()));
        }
        try {
            return (T)this.httpClient.executeRequest(requestBuilder.build(), handler).get();
        }
        catch (Exception e) {
            throw new RuntimeException("An error occurred while invoking " + uri, e);
        }
    }

    public void registerRealm(String host, String username, String password, boolean preemptive, HttpAuthScheme authScheme) {
        host = Assertions.checkNotNull(host, "host cannot be null", new Object[0]);
        username = Assertions.checkNotNull(username, "username cannot be null", new Object[0]);
        password = Assertions.checkNotNull(password, "password cannot be null", new Object[0]);
        authScheme = Assertions.checkNotNull(authScheme, "authScheme cannot be null", new Object[0]);
        this.realms.put(host, new Realm.RealmBuilder().setPrincipal(username).setPassword(password).setUsePreemptiveAuth(preemptive).setScheme(authScheme.getAuthScheme()).build());
    }

    public void registerSSLProxy(File proxyCertificate) {
        this.registerSSLCerificates(proxyCertificate, proxyCertificate, null);
    }

    public void registerSSLCerificates(File sslCertificate, File sslKey, String sslPassword) {
        HttpInvoker.checkFile(sslCertificate);
        HttpInvoker.checkFile(sslKey);
        if (sslPassword == null) {
            sslPassword = "";
        }
        char[] password = sslPassword.toCharArray();
        try {
            KeyStore store = new KeyMaterial(sslCertificate, sslKey, password).getKeyStore();
            store.load(null, password);
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
            keyManagerFactory.init(store, password);
            this.keyManagers.addAll(Arrays.asList(keyManagerFactory.getKeyManagers()));
            this.httpClient.getConfig().getSSLContext().init(this.keyManagers.toArray(new KeyManager[this.keyManagers.size()]), this.trustManagers, null);
        }
        catch (Exception e) {
            throw new IllegalStateException("Impossible to initialize SSL certificate/key", e);
        }
    }

    private static void checkFile(File file) {
        Assertions.checkArgument(file.exists(), "File %s not found, please verify it exists", file);
        Assertions.checkArgument(!file.isDirectory(), "File %s must be not a directory", file);
    }

    public void registerUmSsoAccess(String loginFormUrl, HttpMethod httpMethod, Parameter ... parameters) {
        loginFormUrl = Assertions.checkNotNull(loginFormUrl, "loginFormUrl cannot be null", new Object[0]);
        this.registerUmSsoCredentials(URI.create(loginFormUrl), httpMethod, parameters);
    }

    public void registerUmSsoCredentials(URI loginFormUrl, HttpMethod httpMethod, Parameter ... parameters) {
        loginFormUrl = Assertions.checkNotNull(loginFormUrl, "loginFormUrl cannot be null", new Object[0]);
        httpMethod = Assertions.checkNotNull(httpMethod, "httpMethod cannot be null", new Object[0]);
        parameters = Assertions.checkNotNull(parameters, "loginFormUrl cannot be null", new Object[0]);
        this.umSsoCredentials.put(loginFormUrl.getHost(), new UmSsoAccess(loginFormUrl, httpMethod, parameters));
    }

    public void shutDown() {
        this.httpClient.close();
    }
}

