/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.streaming;

import java.util.Arrays;
import org.apache.hadoop.streaming.DumpTypedBytes;
import org.apache.hadoop.streaming.LoadTypedBytes;
import org.apache.hadoop.streaming.StreamJob;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class HadoopStreaming {
    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            System.err.println("No Arguments Given!");
            System.exit(1);
        }
        int returnStatus = 0;
        String cmd = args[0];
        String[] remainingArgs = Arrays.copyOfRange(args, 1, args.length);
        if (cmd.equalsIgnoreCase("dumptb")) {
            DumpTypedBytes dumptb = new DumpTypedBytes();
            returnStatus = ToolRunner.run((Tool)dumptb, (String[])remainingArgs);
        } else if (cmd.equalsIgnoreCase("loadtb")) {
            LoadTypedBytes loadtb = new LoadTypedBytes();
            returnStatus = ToolRunner.run((Tool)loadtb, (String[])remainingArgs);
        } else if (cmd.equalsIgnoreCase("streamjob")) {
            StreamJob job = new StreamJob();
            returnStatus = ToolRunner.run((Tool)job, (String[])remainingArgs);
        } else {
            StreamJob job = new StreamJob();
            returnStatus = ToolRunner.run((Tool)job, (String[])args);
        }
        if (returnStatus != 0) {
            System.err.println("Streaming Command Failed!");
            System.exit(returnStatus);
        }
    }
}

