/*
 * Decompiled with CFR 0.152.
 */
package com.terradue.jcatalogue.client;

import com.ning.http.client.AsyncCompletionHandler;
import com.ning.http.client.Response;
import com.terradue.jcatalogue.client.CallbackDownloadHandler;
import com.terradue.jcatalogue.client.Catalogue;
import com.terradue.jcatalogue.client.CatalogueDescription;
import com.terradue.jcatalogue.client.CatalogueEntity;
import com.terradue.jcatalogue.client.DataSet;
import com.terradue.jcatalogue.client.HttpAuthScheme;
import com.terradue.jcatalogue.client.HttpMethod;
import com.terradue.jcatalogue.client.Parameter;
import com.terradue.jcatalogue.client.Series;
import com.terradue.jcatalogue.client.download.DownloadHandler;
import com.terradue.jcatalogue.client.download.Downloader;
import com.terradue.jcatalogue.client.download.HttpDownloader;
import com.terradue.jcatalogue.client.download.Protocol;
import com.terradue.jcatalogue.client.geo.Line;
import com.terradue.jcatalogue.client.geo.Point;
import com.terradue.jcatalogue.client.geo.Polygon;
import com.terradue.jcatalogue.client.internal.ahc.HttpInvoker;
import com.terradue.jcatalogue.client.internal.converters.AtomDateConverter;
import com.terradue.jcatalogue.client.internal.converters.CharsetConverter;
import com.terradue.jcatalogue.client.internal.converters.GeoConverter;
import com.terradue.jcatalogue.client.internal.converters.LocaleConverter;
import com.terradue.jcatalogue.client.internal.digester.AtomRulesModule;
import com.terradue.jcatalogue.client.internal.digester.DataSetRulesModule;
import com.terradue.jcatalogue.client.internal.digester.LinkedAtomEntityModule;
import com.terradue.jcatalogue.client.internal.digester.OpenSearchModule;
import com.terradue.jcatalogue.client.internal.digester.SingleDataSetRulesModule;
import com.terradue.jcatalogue.client.internal.lang.Assertions;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.digester3.binder.DigesterLoader;
import org.apache.commons.digester3.binder.RulesModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CatalogueClient {
    private final Map<String, Downloader> downloaders = new HashMap<String, Downloader>();
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final HttpInvoker httpInvoker = new HttpInvoker();
    private final DigesterLoader descriptionDigesterLoader = DigesterLoader.newLoader((RulesModule[])new RulesModule[]{new OpenSearchModule()}).setNamespaceAware(true);
    private final DigesterLoader catalogueDigesterLoader = DigesterLoader.newLoader((RulesModule[])new RulesModule[]{new AtomRulesModule(Catalogue.class), new LinkedAtomEntityModule()}).setNamespaceAware(true);
    private final DigesterLoader serieDigesterLoader = DigesterLoader.newLoader((RulesModule[])new RulesModule[]{new AtomRulesModule(Series.class), new DataSetRulesModule()}).setNamespaceAware(true);
    private final DigesterLoader singleDataSetDigesterLoader = DigesterLoader.newLoader((RulesModule[])new RulesModule[]{new SingleDataSetRulesModule()}).setNamespaceAware(true);

    public CatalogueClient() {
        this.registerDownloader(new HttpDownloader(this.httpInvoker));
    }

    public void registerDownloader(Downloader downloader) {
        downloader = Assertions.checkNotNull(downloader, "Input downloader cannot be null", new Object[0]);
        Assertions.checkArgument(downloader.getClass().isAnnotationPresent(Protocol.class), "Class %s must be annotated with %s", downloader.getClass().getName(), Protocol.class.getName());
        for (String protocol : downloader.getClass().getAnnotation(Protocol.class).value()) {
            this.registerDownloader(protocol, downloader);
        }
    }

    public void registerDownloader(String protocol, Downloader downloader) {
        protocol = Assertions.checkNotNull(protocol, "Input protocol cannot be null", new Object[0]);
        downloader = Assertions.checkNotNull(downloader, "Input downloader cannot be null", new Object[0]);
        this.downloaders.put(protocol, downloader);
    }

    public <D extends Downloader> D lookupDownloader(String protocol) {
        if (!this.downloaders.containsKey(protocol = Assertions.checkNotNull(protocol, "Input protocol cannot be null", new Object[0]))) {
            return null;
        }
        Downloader downloader = this.downloaders.get(protocol);
        return (D)downloader;
    }

    public CatalogueDescription discover(String uri, Parameter ... parameters) {
        return (CatalogueDescription)this.invoke(this.descriptionDigesterLoader, uri, parameters);
    }

    public CatalogueDescription discover(URI uri, Parameter ... parameters) {
        return (CatalogueDescription)this.invoke(this.descriptionDigesterLoader, uri, parameters);
    }

    public Catalogue getCatalogue(String uri, Parameter ... parameters) {
        return (Catalogue)this.invoke(this.catalogueDigesterLoader, uri, parameters);
    }

    public Catalogue getCatalogue(URI uri, Parameter ... parameters) {
        return (Catalogue)this.invoke(this.catalogueDigesterLoader, uri, parameters);
    }

    public Series getSeries(String uri, Parameter ... parameters) {
        return (Series)this.invoke(this.serieDigesterLoader, uri, parameters);
    }

    public Series getSeries(URI uri, Parameter ... parameters) {
        return (Series)this.invoke(this.serieDigesterLoader, uri, parameters);
    }

    public DataSet getDataSet(String uri, Parameter ... parameters) {
        return (DataSet)this.invoke(this.singleDataSetDigesterLoader, uri, parameters);
    }

    public DataSet getDataSet(URI uri, Parameter ... parameters) {
        return (DataSet)this.invoke(this.singleDataSetDigesterLoader, uri, parameters);
    }

    <CE extends CatalogueEntity> CE invoke(DigesterLoader digesterLoader, String uri, Parameter ... parameters) {
        uri = Assertions.checkNotNull(uri, "Input URI cannot be null", new Object[0]);
        try {
            return this.invoke(digesterLoader, new URI(uri), parameters);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(uri + " is not a valid URI", e);
        }
    }

    <CE extends CatalogueEntity> CE invoke(final DigesterLoader digesterLoader, URI uri, Parameter ... parameters) {
        Assertions.checkNotNull(uri, "Input URI cannot be null", new Object[0]);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Invoking Catalogue URI '{}' with parameters: ", (Object)uri, (Object)Arrays.toString(parameters));
        }
        CatalogueEntity description = (CatalogueEntity)this.httpInvoker.invoke(HttpMethod.GET, uri, new AsyncCompletionHandler<CE>(){

            public CE onCompleted(Response response) throws Exception {
                return (CatalogueEntity)digesterLoader.newDigester().parse(response.getResponseBodyAsStream());
            }
        }, parameters);
        description.setCatalogueClient(this);
        return (CE)description;
    }

    void downloadFile(File targetDir, List<URI> fileUris, DownloadHandler handler) {
        if (!targetDir.exists()) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Directory {} does not exist, creating it...", (Object)targetDir);
            }
            if (!targetDir.mkdirs()) {
                throw new RuntimeException(String.format("Impossible to create '%s' directory, please make sure you have enough permissions", targetDir));
            }
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Directory {} created.", (Object)targetDir);
            }
        }
        CallbackDownloadHandler callback = new CallbackDownloadHandler(handler);
        Iterator<URI> fileUrisIterator = fileUris.iterator();
        while (!callback.isDownloaded()) {
            if (!fileUrisIterator.hasNext()) {
                callback.onFatal("DataSet media file download not possible, none of the submitted URIs succeeded");
                return;
            }
            URI fileUri = fileUrisIterator.next();
            Object downloader = this.lookupDownloader(fileUri.getScheme());
            if (downloader != null) {
                downloader.download(targetDir, fileUri, callback);
                continue;
            }
            callback.onWarning(String.format("'%s' protocol is not supported, impossible to download %s", fileUri.getScheme(), fileUri));
        }
    }

    public void registerRealm(String host, String username, String password, boolean preemptive, HttpAuthScheme authScheme) {
        this.httpInvoker.registerRealm(host, username, password, preemptive, authScheme);
    }

    public void registerSSLProxy(File proxyCertificate) {
        this.httpInvoker.registerSSLProxy(proxyCertificate);
    }

    public void registerSSLCerificates(File sslCertificate, File sslKey, String sslPassword) {
        this.httpInvoker.registerSSLCerificates(sslCertificate, sslKey, sslPassword);
    }

    public void registerUmSsoAccess(String loginFormUrl, HttpMethod httpMethod, Parameter ... parameters) {
        this.httpInvoker.registerUmSsoAccess(loginFormUrl, httpMethod, parameters);
    }

    public void registerUmSsoCredentials(URI loginFormUrl, HttpMethod httpMethod, Parameter ... parameters) {
        this.httpInvoker.registerUmSsoCredentials(loginFormUrl, httpMethod, parameters);
    }

    public void shutDown() {
        this.httpInvoker.shutDown();
    }

    public HttpInvoker getHttpInvoker() {
        return this.httpInvoker;
    }

    static {
        ConvertUtils.register((Converter)new AtomDateConverter(), Date.class);
        ConvertUtils.register((Converter)new LocaleConverter(), Locale.class);
        ConvertUtils.register((Converter)new CharsetConverter(), Charset.class);
        GeoConverter geoConverter = new GeoConverter();
        ConvertUtils.register((Converter)geoConverter, Line.class);
        ConvertUtils.register((Converter)geoConverter, Point.class);
        ConvertUtils.register((Converter)geoConverter, Polygon.class);
    }
}

