/*
 * Decompiled with CFR 0.152.
 */
package com.terradue.jcatalogue.client;

import com.terradue.jcatalogue.client.AtomEntity;
import com.terradue.jcatalogue.client.download.DownloadHandler;
import com.terradue.jcatalogue.client.geo.GeoLocation;
import java.io.File;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DataSet
extends AtomEntity {
    private static final Logger logger = LoggerFactory.getLogger(DataSet.class);
    private Date beginPosition;
    private Date endPosition;
    private GeoLocation geoLocation;

    public void download(File targetDir, DownloadHandler handler) {
        if (logger.isInfoEnabled()) {
            logger.info("Downloading DataSet {} media file...", (Object)this.getId());
        }
        this.getCatalogueClient().downloadFile(targetDir, this.getEnclosures(), handler);
    }

    public Date getBeginPosition() {
        return this.beginPosition;
    }

    public Date getEndPosition() {
        return this.endPosition;
    }

    public GeoLocation getGeoLocation() {
        return this.geoLocation;
    }

    public void setBeginPosition(Date beginPosition) {
        this.beginPosition = beginPosition;
    }

    public void setEndPosition(Date endPosition) {
        this.endPosition = endPosition;
    }

    public void setGeoLocation(GeoLocation geoLocation) {
        this.geoLocation = geoLocation;
    }

    @Override
    public String toString() {
        return "DataSet(beginPosition=" + this.getBeginPosition() + ", endPosition=" + this.getEndPosition() + ", geoLocation=" + this.getGeoLocation() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataSet)) {
            return false;
        }
        DataSet other = (DataSet)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getBeginPosition() == null ? other.getBeginPosition() != null : !this.getBeginPosition().equals(other.getBeginPosition())) {
            return false;
        }
        if (this.getEndPosition() == null ? other.getEndPosition() != null : !this.getEndPosition().equals(other.getEndPosition())) {
            return false;
        }
        return !(this.getGeoLocation() == null ? other.getGeoLocation() != null : !this.getGeoLocation().equals(other.getGeoLocation()));
    }

    @Override
    public boolean canEqual(Object other) {
        return other instanceof DataSet;
    }

    @Override
    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = result * 31 + super.hashCode();
        result = result * 31 + (this.getBeginPosition() == null ? 0 : this.getBeginPosition().hashCode());
        result = result * 31 + (this.getEndPosition() == null ? 0 : this.getEndPosition().hashCode());
        result = result * 31 + (this.getGeoLocation() == null ? 0 : this.getGeoLocation().hashCode());
        return result;
    }
}

