/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsShell;
import org.apache.hadoop.fs.permission.ChmodParser;
import org.apache.hadoop.fs.permission.FsPermission;

class FsShellPermissions {
    static String CHMOD_USAGE = "-chmod [-R] <MODE[,MODE]... | OCTALMODE> PATH...";
    private static ChmodParser pp;
    private static String allowedChars;
    private static Pattern chownPattern;
    private static Pattern chgrpPattern;
    static String CHOWN_USAGE;
    static String CHGRP_USAGE;

    FsShellPermissions() {
    }

    static int changePermissions(FileSystem fs, String cmd, String[] argv, int startIndex, FsShell shell) throws IOException {
        FsShell.CmdHandler handler = null;
        boolean recursive = false;
        while (startIndex < argv.length && argv[startIndex].equals("-R")) {
            recursive = true;
            ++startIndex;
        }
        if (startIndex >= argv.length) {
            throw new IOException("Not enough arguments for the command");
        }
        if (cmd.equals("-chmod")) {
            handler = new ChmodHandler(fs, argv[startIndex++]);
        } else if (cmd.equals("-chown")) {
            handler = new ChownHandler(fs, argv[startIndex++]);
        } else if (cmd.equals("-chgrp")) {
            handler = new ChgrpHandler(fs, argv[startIndex++]);
        }
        return shell.runCmdHandler(handler, argv, startIndex, recursive);
    }

    static {
        allowedChars = "[-_./@a-zA-Z0-9]";
        chownPattern = Pattern.compile("^\\s*(" + allowedChars + "+)?" + "([:](" + allowedChars + "*))?\\s*$");
        chgrpPattern = Pattern.compile("^\\s*(" + allowedChars + "+)\\s*$");
        CHOWN_USAGE = "-chown [-R] [OWNER][:[GROUP]] PATH...";
        CHGRP_USAGE = "-chgrp [-R] GROUP PATH...";
    }

    private static class ChgrpHandler
    extends ChownHandler {
        ChgrpHandler(FileSystem fs, String groupStr) throws IOException {
            super("chgrp", fs);
            Matcher matcher = chgrpPattern.matcher(groupStr);
            if (!matcher.matches()) {
                throw new IOException("'" + groupStr + "' does not match " + "expected pattern for group");
            }
            this.group = matcher.group(1);
        }
    }

    private static class ChownHandler
    extends FsShell.CmdHandler {
        protected String owner = null;
        protected String group = null;

        protected ChownHandler(String cmd, FileSystem fs) {
            super(cmd, fs);
        }

        ChownHandler(FileSystem fs, String ownerStr) throws IOException {
            super("chown", fs);
            Matcher matcher = chownPattern.matcher(ownerStr);
            if (!matcher.matches()) {
                throw new IOException("'" + ownerStr + "' does not match " + "expected pattern for [owner][:group].");
            }
            this.owner = matcher.group(1);
            this.group = matcher.group(3);
            if (this.group != null && this.group.length() == 0) {
                this.group = null;
            }
            if (this.owner == null && this.group == null) {
                throw new IOException("'" + ownerStr + "' does not specify " + " owner or group.");
            }
        }

        @Override
        public void run(FileStatus file, FileSystem srcFs) throws IOException {
            String newGroup;
            String newOwner = this.owner == null || this.owner.equals(file.getOwner()) ? null : this.owner;
            String string = newGroup = this.group == null || this.group.equals(file.getGroup()) ? null : this.group;
            if (newOwner != null || newGroup != null) {
                try {
                    srcFs.setOwner(file.getPath(), newOwner, newGroup);
                }
                catch (IOException e) {
                    System.err.println(this.getName() + ": changing ownership of '" + file.getPath() + "':" + e.getMessage().split("\n")[0]);
                }
            }
        }
    }

    private static class ChmodHandler
    extends FsShell.CmdHandler {
        ChmodHandler(FileSystem fs, String modeStr) throws IOException {
            super("chmod", fs);
            try {
                pp = new ChmodParser(modeStr);
            }
            catch (IllegalArgumentException iea) {
                this.patternError(iea.getMessage());
            }
        }

        private void patternError(String mode) throws IOException {
            throw new IOException("chmod : mode '" + mode + "' does not match the expected pattern.");
        }

        @Override
        public void run(FileStatus file, FileSystem srcFs) throws IOException {
            short newperms = pp.applyNewPermission(file);
            if (file.getPermission().toShort() != newperms) {
                try {
                    srcFs.setPermission(file.getPath(), new FsPermission(newperms));
                }
                catch (IOException e) {
                    FsShell.LOG.debug((Object)"Error", (Throwable)e);
                    System.err.println(this.getName() + ": changing permissions of '" + file.getPath() + "':" + e.getMessage().split("\n")[0]);
                }
            }
        }
    }
}

