/*
 * Decompiled with CFR 0.152.
 */
package com.terradue.wps_hadoop.processes.examples.tiff_uploader;

import com.terradue.gtuploader.GeoTIFFUploader;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.UUID;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TIFFUploaderMapper
extends MapReduceBase
implements Mapper<LongWritable, Text, LongWritable, Text> {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    public final UUID SessionUID = UUID.randomUUID();
    private GeoTIFFUploader uploader = null;

    public void configure(JobConf job) {
        String restServerPassword;
        String restServerHost = job.get("restServerHost");
        int restServerPort = job.getInt("restServerPort", 80);
        int requestTimeout = job.getInt("requestTimeout", 120);
        String restBasePath = job.get("restBasePath");
        GeoTIFFUploader.Builder builder = new GeoTIFFUploader.Builder().setRestServerHost(restServerHost).setRestServerPort(restServerPort).setRequestTimeout(requestTimeout).setRestBasePath(restBasePath);
        String restServerUsername = job.get("restServerUsername");
        if (restServerUsername != null) {
            builder.setRestServerUsername(restServerUsername);
        }
        if ((restServerPassword = job.get("restServerPassword")) != null) {
            builder.setRestServerPassword(restServerPassword);
        }
        this.uploader = builder.newGeoTIFFUploader();
    }

    public void map(LongWritable key, Text value, OutputCollector<LongWritable, Text> output, Reporter reporter) throws IOException {
        URL line = new URL(value.toString());
        File toBeConverted = new File(System.getProperty("catalina.base") + "/webapps/wps/store/IMarine/tmp/" + this.SessionUID + "/" + line.getFile());
        toBeConverted.getParentFile().mkdirs();
        this.copyURLToFile(line, toBeConverted);
        this.doMap(toBeConverted);
        output.collect((Object)key, (Object)new Text(""));
    }

    public void doMap(File toBeConverted) {
        try {
            this.uploader.convertAndUpload(toBeConverted);
        }
        catch (Throwable t) {
            this.logger.error("An error occurred while converting " + toBeConverted, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyURLToFile(URL url, File f) {
        BufferedInputStream in = null;
        FileOutputStream fout = null;
        try {
            int count;
            URLConnection uc = url.openConnection();
            if (uc == null) {
                throw new RuntimeException("Connection failed");
            }
            String contentType = uc.getContentType();
            if (contentType == null) {
                throw new RuntimeException("Content type is null or the file doesn't exists");
            }
            int contentLength = uc.getContentLength();
            if (contentLength == 0) {
                throw new RuntimeException("Content length is 0");
            }
            in = new BufferedInputStream(url.openStream());
            fout = new FileOutputStream(f);
            byte[] data = new byte[1024];
            while ((count = in.read(data, 0, 1024)) != -1) {
                fout.write(data, 0, count);
            }
        }
        catch (IOException e) {
            try {
                this.logger.error("Impossible to download '" + url + "' to '" + f + "'", (Throwable)e);
            }
            catch (Throwable throwable) {
                TIFFUploaderMapper.closeQuietly(in);
                TIFFUploaderMapper.closeQuietly(fout);
                throw throwable;
            }
            TIFFUploaderMapper.closeQuietly(in);
            TIFFUploaderMapper.closeQuietly(fout);
        }
        TIFFUploaderMapper.closeQuietly(in);
        TIFFUploaderMapper.closeQuietly(fout);
    }

    private static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

