package org.gcube.data.harmonization.occurrence.impl.readers;

import java.io.File;

import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.harmonization.occurrence.OccurrenceStreamer;
import org.gcube.data.harmonization.occurrence.impl.ReconciliationImpl;
import org.gcube.data.spd.plugin.fwk.model.OccurrencePoint;
import org.gcube.data.spd.plugin.fwk.writers.rswrapper.ResultWrapper;

public abstract class OccurrenceReader implements OccurrenceStreamer{

	protected static final GCUBELog logger=new GCUBELog(OccurrenceReader.class);
	
	protected StreamProgress progress=new StreamProgress();
	protected ResultWrapper<OccurrencePoint> wrapper;
	protected File toRead;
	protected ParserConfiguration configuration;
	
	public OccurrenceReader(File toRead,
			ParserConfiguration configuration) {
		super();		
		this.toRead = toRead;
		this.configuration = configuration;
	}
	
	@Override
	public StreamProgress getProgress() {
		return progress;
	}
	public void setWrapper(ResultWrapper<OccurrencePoint> wrapper) {
		this.wrapper = wrapper;
	}
	@Override
	public String getLocator() throws Exception {
		return wrapper.getLocator();
	}
}
