/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.harmonization.occurrence;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.data.analysis.statisticalmanager.proxies.StatisticalManagerDSL;
import org.gcube.data.analysis.statisticalmanager.proxies.StatisticalManagerDataSpace;
import org.gcube.data.analysis.statisticalmanager.proxies.StatisticalManagerDataSpaceImporter;
import org.gcube.data.analysis.statisticalmanager.proxies.StatisticalManagerFactory;
import org.gcube.data.analysis.statisticalmanager.proxies.StatisticalManagerService;
import org.gcube.data.harmonization.occurrence.Reconciliation;
import org.gcube.data.harmonization.occurrence.model.ImportedOccurrenceSet;
import org.gcube.data.harmonization.occurrence.model.PagedRequestSettings;
import org.gcube.data.harmonization.occurrence.model.SubmittedOperation;
import org.gcube.data.harmonization.occurrence.model.db.TableConnectionDescriptor;
import org.gcube.data.harmonization.occurrence.model.statistical.StatisticalOperation;
import org.gcube.data.harmonization.occurrence.model.statistical.StatisticalParameter;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.TableTemplates;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.Feature;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.Features;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMComputation;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMParameter;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMTableMetadata;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMTypeParameter;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.StatisticalServiceType;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.StringValues;

public class ReconciliationImpl
implements Reconciliation {
    private static final GCUBELog logger = new GCUBELog(ReconciliationImpl.class);
    private GCUBEScope scope;
    private String user;
    private StatisticalManagerService service;
    private StatisticalManagerFactory factory;
    private StatisticalManagerDataSpace dataSpace;
    private StatisticalManagerDataSpaceImporter importer;
    private TableConnectionDescriptor tableConn;

    public ReconciliationImpl(GCUBEScope scope, String user) {
        logger.trace((Object)("Scope is " + scope));
        this.scope = scope;
        this.user = user;
        ScopeProvider.instance.set(scope.toString());
        this.factory = (StatisticalManagerFactory)StatisticalManagerDSL.createStateful().build();
        W3CEndpointReference address = this.factory.serviceConnect(user);
        this.service = (StatisticalManagerService)StatisticalManagerDSL.stateful().at(address).build();
        this.dataSpace = (StatisticalManagerDataSpace)StatisticalManagerDSL.dataSpace().build();
    }

    @Override
    public String importOccurrenceFromWorkspace(String fileId) {
        return null;
    }

    @Override
    public List<ImportedOccurrenceSet> getImportedList() {
        ArrayList<ImportedOccurrenceSet> toReturn = new ArrayList<ImportedOccurrenceSet>();
        SMTableMetadata[] sMTableMetadataArray = this.dataSpace.getTableMetadata(this.user).getList();
        int n = sMTableMetadataArray.length;
        int n2 = 0;
        while (n2 < n) {
            SMTableMetadata meta = sMTableMetadataArray[n2];
            toReturn.add(new ImportedOccurrenceSet(meta.getName(), meta.getId(), meta.getCreationDate(), meta.getDescription()));
            ++n2;
        }
        return toReturn;
    }

    @Override
    public String getJSONImported(PagedRequestSettings settings) throws Exception {
        if (this.tableConn == null) {
            throw new Exception("Table connection not opened");
        }
        return this.tableConn.getJSON(settings);
    }

    @Override
    public List<StatisticalOperation> getCapabilities() {
        String[] template = new String[]{TableTemplates.OCCURRENCE_SPECIES.toString()};
        StringValues values = new StringValues(template);
        ArrayList<StatisticalOperation> toReturn = new ArrayList<StatisticalOperation>();
        Features features = this.factory.getFeaturesForInputParameters(new SMTypeParameter(StatisticalServiceType.TABULAR, values));
        Feature[] featureArray = features.getList();
        int n = featureArray.length;
        int n2 = 0;
        while (n2 < n) {
            Feature f = featureArray[n2];
            String[] stringArray = f.getAlgorithms();
            int n3 = stringArray.length;
            int n4 = 0;
            while (n4 < n3) {
                String algorithm = stringArray[n4];
                SMComputation computation = new SMComputation(algorithm, f.getCategory(), "");
                ArrayList<StatisticalParameter> params = new ArrayList<StatisticalParameter>();
                SMParameter[] sMParameterArray = this.factory.getAlgorithmParameters(computation).getList();
                int n5 = sMParameterArray.length;
                int n6 = 0;
                while (n6 < n5) {
                    SMParameter param = sMParameterArray[n6];
                    params.add(new StatisticalParameter("" + param.getType().getName(), param.getName(), param.getDefaultValue(), param.getDescription()));
                    ++n6;
                }
                toReturn.add(new StatisticalOperation(params, algorithm, "" + f.getCategory(), ""));
                ++n4;
            }
            ++n2;
        }
        return toReturn;
    }

    @Override
    public void getResult(String operationId) {
    }

    @Override
    public String saveResultToWorkspace(String operationId) {
        return null;
    }

    @Override
    public String submitUnaryOperation(String importedId, String operation, Map<String, String> parameters) {
        return null;
    }

    @Override
    public List<SubmittedOperation> getSubmittedOperationList() {
        return null;
    }

    @Override
    public synchronized List<String> openTableInspection(String tableId) throws Exception {
        if (this.tableConn != null) {
            this.tableConn.close();
        }
        this.tableConn = new TableConnectionDescriptor(this.dataSpace.getDBParameters(tableId), tableId);
        return this.tableConn.getColumns();
    }

    @Override
    public synchronized void closeTableConnection() throws Exception {
        if (this.tableConn != null) {
            this.tableConn.close();
        }
        this.tableConn = null;
    }
}

