package org.gcube.data.oai.tmplugin.requests;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

import org.gcube.data.oai.tmplugin.Constants;

/**
 * A {@link Request} to bind the OAI Plugin to a single data source formed of all the records in one ore more sets of an OAI repository.
 *  
 * @author Fabio Simeoni
 *
 */
@XmlRootElement(namespace = Constants.NS)
public class WrapRepositoryRequest extends Request {

	@XmlElement
	private String id;

	@XmlElement
	private String name;

	@XmlElement
	private String description;

	protected WrapRepositoryRequest() {
	}

	/**
	 * Creates an instance with a given source identifier and the URL of a given OAI repository.
	 * @param id the source identifier
	 * @param url the URL
	 * @throws IllegalArgumentException if the identifier is null or empty
	 */
	public WrapRepositoryRequest(String id, String url) throws IllegalArgumentException {

		super(url);

		if (id == null || id.isEmpty())
			throw new IllegalArgumentException("repository identifier is null or empty");

		this.id = id;
	}

	/**
	 * Returns the identifier of the source to bind.
	 * @return the identifier
	 */
	public String id() {
		return id;
	}

	/**
	 * Returns a name for the source to bind.
	 * @return the name
	 */
	public String name() {
		return name;
	}

	/**
	 * Sets a name for the source to bind.
	 * @param name the name
	 */
	public void setName(String name) {
		this.name = name;
	}

	/**
	 * Returns a description of the source to bind.
	 * @return the description
	 */
	public String description() {
		return description;
	}

	/**
	 * Sets a description for the source to bind.
	 * @param description the description
	 */
	public void setDescription(String description) {
		this.description = description;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = super.hashCode();
		result = prime * result
				+ ((description == null) ? 0 : description.hashCode());
		result = prime * result + ((id == null) ? 0 : id.hashCode());
		result = prime * result + ((name == null) ? 0 : name.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (!super.equals(obj))
			return false;
		if (getClass() != obj.getClass())
			return false;
		WrapRepositoryRequest other = (WrapRepositoryRequest) obj;
		if (description == null) {
			if (other.description != null)
				return false;
		} else if (!description.equals(other.description))
			return false;
		if (id == null) {
			if (other.id != null)
				return false;
		} else if (!id.equals(other.id))
			return false;
		if (name == null) {
			if (other.name != null)
				return false;
		} else if (!name.equals(other.name))
			return false;
		return true;
	}


}
