/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.publishing.ckan2zenodo;

import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.List;
import org.gcube.data.publishing.ckan2zenodo.commons.Parsing;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Fixer {
    private static final Logger log = LoggerFactory.getLogger(Fixer.class);
    private static DateTimeFormatter INCOMING_FORMATTER = null;
    private static DateTimeFormatter INTERNAL_FORMATTER = null;

    public static final String fixIncoming(String toFix) {
        DocumentContext ctx = JsonPath.using((Configuration)Parsing.JSON_PATH_ALWAYS_LIST_CONFIG).parse(toFix);
        DocumentContext pathCtx = JsonPath.using((Configuration)Parsing.JSON_PATH_PATHS_CONFIGURATION).parse(toFix);
        ctx = Fixer.fixIncomingDate(ctx, pathCtx, "$.created");
        ctx = Fixer.fixIncomingDate(ctx, pathCtx, "$.modified");
        ctx = Fixer.fixIncomingDate(ctx, pathCtx, "$..publication_date");
        ctx = Fixer.fixIncomingDate(ctx, pathCtx, "$..embargo_date");
        return ctx.jsonString();
    }

    public static String fixSending(String toFix) {
        DocumentContext ctx = JsonPath.using((Configuration)Parsing.JSON_PATH_ALWAYS_LIST_CONFIG).parse(toFix);
        DocumentContext pathCtx = JsonPath.using((Configuration)Parsing.JSON_PATH_PATHS_CONFIGURATION).parse(toFix);
        ctx = Fixer.fixOutgoingDate(ctx, pathCtx, "$.created");
        ctx = Fixer.fixOutgoingDate(ctx, pathCtx, "$.modified");
        ctx = Fixer.fixOutgoingDate(ctx, pathCtx, "$..publication_date");
        ctx = Fixer.fixOutgoingDate(ctx, pathCtx, "$..embargo_date");
        return ctx.jsonString();
    }

    private static final DocumentContext fixIncomingDate(DocumentContext valuesCtx, DocumentContext pathCtx, String toFixPath) {
        try {
            List values = (List)valuesCtx.read(toFixPath, new Predicate[0]);
            List paths = (List)pathCtx.read(toFixPath, new Predicate[0]);
            if (values != null) {
                for (int i = 0; i < values.size(); ++i) {
                    String toFix = (String)values.get(i);
                    if (toFix == null) continue;
                    JsonPath path = JsonPath.compile((String)((String)paths.get(i)), (Predicate[])new Predicate[0]);
                    valuesCtx.set(path, (Object)Fixer.fixIncomingDateString(toFix));
                }
            }
        }
        catch (Throwable e) {
            log.warn("Unable to fix " + toFixPath + ". Cause : ", e);
        }
        return valuesCtx;
    }

    public static final String fixIncomingDateString(String toFix) throws Exception {
        TemporalAccessor accessor = INCOMING_FORMATTER.parse(toFix);
        ZonedDateTime zTime = null;
        if (!accessor.isSupported(ChronoField.HOUR_OF_DAY)) {
            LocalDate date = LocalDate.from(accessor);
            return date.toString();
        }
        zTime = LocalDateTime.from(accessor).atZone(ZoneOffset.UTC);
        return zTime.format(INTERNAL_FORMATTER);
    }

    private static final DocumentContext fixOutgoingDate(DocumentContext valuesCtx, DocumentContext pathCtx, String toFixPath) {
        try {
            List values = (List)valuesCtx.read(toFixPath, new Predicate[0]);
            List paths = (List)pathCtx.read(toFixPath, new Predicate[0]);
            if (values != null) {
                for (int i = 0; i < values.size(); ++i) {
                    String toFix = (String)values.get(i);
                    if (toFix == null) continue;
                    JsonPath path = JsonPath.compile((String)((String)paths.get(i)), (Predicate[])new Predicate[0]);
                    valuesCtx.set(path, (Object)(toFix.substring(0, toFix.length() - 2) + ":" + toFix.substring(toFix.length() - 2, toFix.length())));
                }
            }
        }
        catch (Throwable t) {
            log.warn("Unable to fix " + toFixPath + ".Cause : ", t);
        }
        return valuesCtx;
    }

    static {
        INCOMING_FORMATTER = DateTimeFormatter.ofPattern("[yyyy-MM-dd['T'HH:mm:ss[.SSSSSS[z][Z][XXX]]]]");
        INTERNAL_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSSSSZ");
    }
}

