package org.gcube.data.publishing.gis.publisher;

import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.informationsystem.ISException;
import org.gcube.common.core.informationsystem.client.AtomicCondition;
import org.gcube.common.core.informationsystem.client.ISClient;
import org.gcube.common.core.informationsystem.client.ISClient.ISMalformedQueryException;
import org.gcube.common.core.informationsystem.client.queries.GCUBERuntimeResourceQuery;
import org.gcube.common.core.resources.GCUBERuntimeResource;
import org.gcube.common.core.resources.runtime.AccessPoint;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.publishing.gis.publisher.csquare.CSQuarePolygonDBDescriptor;
import org.gcube.data.publishing.gis.publisher.csquare.CSquareConverterImpl;
import org.gcube.data.publishing.gis.publisher.csquare.SQLType;
import org.gcube.data.publishing.gis.publisher.csquare.WorldTable;
import org.gcube.data.publishing.gis.publisher.plugin.fwk.CSquareConverter;
import org.gcube.data.publishing.gis.publisher.plugin.fwk.GISInteractionFactory;
import org.gcube.data.publishing.gis.publisher.plugin.fwk.model.faults.RepositoryTypeNotSupportedException;
import org.gcube.data.publishing.gis.publisher.plugin.fwk.model.types.GISDataType;
import org.gcube.data.publishing.gis.publisher.plugin.fwk.model.types.GISRepositoryType;
import org.gcube.data.publishing.gis.publisher.plugins.InteractionWrapper;

public class PluginManager {
	private static ServiceLoader<GISInteractionFactory> loader=null;

	private static final GCUBELog logger=new GCUBELog(PluginManager.class);


	protected static ISClient isClient;


	static{
		loader= ServiceLoader.load(GISInteractionFactory.class);
		try {
			isClient = GHNContext.getImplementation(ISClient.class);
		} catch (Exception e) {
			logger.fatal("",e);
		}
	}


	private static ConcurrentHashMap<GCUBEScope, PluginManager> instancesMap=new ConcurrentHashMap<GCUBEScope, PluginManager>();

	public static synchronized PluginManager get(GCUBEScope scope) {
		if(!instancesMap.containsKey(scope)){
			PluginManager toInit=new PluginManager(scope);
			toInit.init();
			instancesMap.put(scope, toInit);
		}
		return instancesMap.get(scope);
	}




	private GCUBEScope scope=null;
	private EnumMap<GISRepositoryType, GISInteractionFactory> pluginMap=new EnumMap<GISRepositoryType, GISInteractionFactory>(GISRepositoryType.class);
	private CSQuarePolygonDBDescriptor csquareDB=null;


	private PluginManager(GCUBEScope scope) {
		this.scope=scope;
	}

	public GCUBEScope getScope() {
		return scope;
	}

	private void init() {
		logger.trace("checking plugin availability under scope "+scope);
		for(GISInteractionFactory factory : loader){
			logger.trace("Initializing "+factory.getHandledRepositoryType()+" interaction factory");
			if(factory.init(scope))	pluginMap.put(factory.getHandledRepositoryType(), factory);
			else logger.warn("Factory not initialized");
		}

		try {
			csquareDB=getCSquareDBInScope(scope);
			logger.trace("CSQUARE DB IS "+csquareDB);
		} catch (Exception e) {
			logger.warn("Unable to locate Csquare DB",e);
		}
	}

	public InteractionWrapper getInteractionPlugin(GISRepositoryType type)throws Exception{
		CSquareConverter converter=null;
		if(csquareDB==null){
			try {
				csquareDB=getCSquareDBInScope(scope);
				logger.trace("CSQUARE DB IS "+csquareDB);				
			} catch (Exception e) {
				logger.warn("Unable to locate Csquare DB",e);
			}		
		}
		converter=new CSquareConverterImpl(csquareDB,scope);
		if(pluginMap.containsKey(type)) return new InteractionWrapper(pluginMap.get(type).createInteraction(converter));
		else throw new RepositoryTypeNotSupportedException("Type ["+type+"] not found under scope "+scope);
	}

	public Set<GISRepositoryType> getHandledRepositories(){
		return pluginMap.keySet();
	}

	public List<GISDataType> getHandledDataType(GISRepositoryType repoType){
		return pluginMap.get(repoType).getHandledDataType();
	}

	private static CSQuarePolygonDBDescriptor getCSquareDBInScope(GCUBEScope scope) throws InstantiationException, IllegalAccessException, ISMalformedQueryException, ISException{
		GCUBERuntimeResourceQuery runtimeQuery=isClient.getQuery(GCUBERuntimeResourceQuery.class);
		runtimeQuery.addAtomicConditions(new AtomicCondition("//Profile/Category", "Database"));
		runtimeQuery.addAtomicConditions(new AtomicCondition("//Profile/Platform/Name", "postgis"));
		runtimeQuery.addAtomicConditions(new AtomicCondition("//Profile/Name","Geoserver database "));
		List<GCUBERuntimeResource> list=isClient.execute(runtimeQuery, scope);

		for(GCUBERuntimeResource rr:list){
			for(AccessPoint access:rr.getAccessPoints()){
				CSQuarePolygonDBDescriptor toReturn=new CSQuarePolygonDBDescriptor("jdbc:postgresql:"+access.getEndpoint(), access.getUsername(), access.getPassword());
				HashMap<String,SQLType> fields=new HashMap<String, SQLType>();
				fields.put("gid", SQLType.SERIAL);
				fields.put("csquarecode", SQLType.STRING);
				fields.put("the_geom", SQLType.GEOMETRY);
				toReturn.getWorldTables().add(new WorldTable(0, fields, "world", 0.5d));
				return toReturn;
			}
		}	
		return null;
	}
}
