package org.gcube.data.publishing.gis.publisher.reports;

import java.util.UUID;

import com.j256.ormlite.field.DataType;
import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.table.DatabaseTable;

@DatabaseTable(tableName="activities")
public class StoredReport {

	@DatabaseField(generatedId = true)
	private UUID id;
	@DatabaseField(dataType=DataType.LONG_STRING)
	private String serializedReport;
	@DatabaseField
	private Status status;
	
	public StoredReport() {
		// TODO Auto-generated constructor stub
	}

	public StoredReport(String serializedReport, Status status) {
		super();		
		this.serializedReport = serializedReport;
		this.status = status;
	}

	/**
	 * @return the id
	 */
	public UUID getId() {
		return id;
	}

	/**
	 * @param id the id to set
	 */
	public void setId(UUID id) {
		this.id = id;
	}

	/**
	 * @return the serializedReport
	 */
	public String getSerializedReport() {
		return serializedReport;
	}

	/**
	 * @param serializedReport the serializedReport to set
	 */
	public void setSerializedReport(String serializedReport) {
		this.serializedReport = serializedReport;
	}

	/**
	 * @return the status
	 */
	public Status getStatus() {
		return status;
	}

	/**
	 * @param status the status to set
	 */
	public void setStatus(Status status) {
		this.status = status;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("StoredReport [id=");
		builder.append(id);
		builder.append(", serializedReport=");
		builder.append(serializedReport);
		builder.append(", status=");
		builder.append(status);
		builder.append("]");
		return builder.toString();
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#hashCode()
	 */
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((id == null) ? 0 : id.hashCode());
		return result;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		StoredReport other = (StoredReport) obj;
		if (id == null) {
			if (other.id != null)
				return false;
		} else if (!id.equals(other.id))
			return false;
		return true;
	}

	
	
	
}
