/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datapublishing.sdmx.datasource.tabman.querymanager.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.gcube.datapublishing.sdmx.datasource.data.ResultSetExtractor;
import org.gcube.datapublishing.sdmx.datasource.data.ResultSetExtractorAbstractImpl;
import org.gcube.datapublishing.sdmx.datasource.data.beans.AttributeColumnBean;
import org.gcube.datapublishing.sdmx.datasource.data.beans.DimensionColumnBean;
import org.gcube.datapublishing.sdmx.datasource.series.model.ObservationModel;
import org.gcube.datapublishing.sdmx.datasource.series.model.SeriesModel;
import org.gcube.datapublishing.sdmx.datasource.tabman.querymanager.json.RowModel;
import org.gcube.datapublishing.sdmx.datasource.tabman.querymanager.json.Rows;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TabmanResultSetExtractor
extends ResultSetExtractorAbstractImpl
implements ResultSetExtractor {
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private Map<String, SeriesModel> seriesModelMap = new HashMap<String, SeriesModel>();

    public void processRows(Rows rows) {
        List<RowModel> rowModels = rows.getRows();
        DimensionColumnBean seriesColumn = this.getSeriesColumnId();
        int seriesColumnIdPosition = this.metadataProvider.getDataPosition(seriesColumn.getId());
        int timeDimensionColumnIdPosition = this.metadataProvider.getDataPosition(this.metadataProvider.getTimeDimension().getId());
        int primaryMeasureColumnIdPosition = this.metadataProvider.getDataPosition(this.metadataProvider.getPrimaryMeasure().getId());
        for (int i = 0; i < rowModels.size(); ++i) {
            this.logger.debug("Row " + i);
            this.processRow(rowModels.get(i), seriesColumnIdPosition, timeDimensionColumnIdPosition, primaryMeasureColumnIdPosition);
        }
    }

    private void processRow(RowModel rowModel, int seriesColumnIdPosition, int timeDimensionColumnIdPosition, int primaryMeasureColumnIdPosition) {
        this.logger.debug("Processing new row");
        String serieKeyValue = rowModel.getElement(seriesColumnIdPosition);
        this.logger.debug("Series key value " + serieKeyValue);
        SeriesModel seriesModel = this.seriesModelMap.get(serieKeyValue);
        if (seriesModel == null) {
            seriesModel = this.generateNewSeriesModel(rowModel);
            this.seriesModelMap.put(serieKeyValue, seriesModel);
        }
        ObservationModel observation = new ObservationModel();
        String observationTime = rowModel.getElement(timeDimensionColumnIdPosition);
        String observationValue = rowModel.getElement(primaryMeasureColumnIdPosition);
        this.logger.debug("Adding observation of " + observationTime + " = " + observationValue);
        observation.setId(observationTime);
        observation.setValue(observationValue);
        this.logger.debug("Adding observation attributes");
        List attributes = this.metadataProvider.getObservationAttributes();
        for (AttributeColumnBean attribute : attributes) {
            String attributeColumnId = attribute.getId();
            String attributeColumnLabel = attribute.getConcept();
            String attributeValue = rowModel.getElement(this.metadataProvider.getDataPosition(attributeColumnId));
            this.logger.debug("Adding observation attribute column " + attributeColumnId + " called " + attributeColumnLabel + " value " + attributeValue);
            if (attributeValue != null) {
                observation.addAttribute(attributeColumnLabel, attributeValue);
                continue;
            }
            this.logger.warn("Observation attribute not found");
        }
        seriesModel.addObservations(observation);
    }

    private DimensionColumnBean getSeriesColumnId() {
        Iterator dimensions = this.metadataProvider.getDimensions().iterator();
        DimensionColumnBean response = null;
        while (dimensions.hasNext() && response == null) {
            DimensionColumnBean dimension = (DimensionColumnBean)dimensions.next();
            if (dimension.isMeasureDimension() || dimension.isTimeDimension()) continue;
            response = dimension;
        }
        return response;
    }

    private SeriesModel generateNewSeriesModel(RowModel rowModel) {
        this.logger.debug("New series key, adding dimensions");
        SeriesModel response = new SeriesModel();
        this.logger.debug("Adding generic dimensions");
        List dimensions = this.metadataProvider.getDimensions();
        for (DimensionColumnBean dimension : dimensions) {
            String dimensionColumnId = dimension.getId();
            String dimensionColumnLabel = dimension.getConcept();
            String dimensionValue = rowModel.getElement(this.metadataProvider.getDataPosition(dimensionColumnId));
            this.logger.debug("Adding dimension column " + dimensionColumnId + " called " + dimensionColumnLabel + " value " + dimensionValue);
            if (dimensionValue != null) {
                response.addSeriesDimensions(dimensionColumnLabel, dimensionValue);
                continue;
            }
            this.logger.warn("Dimension not found");
        }
        List attributes = this.metadataProvider.getDimensionAttributes();
        for (AttributeColumnBean attribute : attributes) {
            String attributeColumnId = attribute.getId();
            String attributeColumnLabel = attribute.getConcept();
            String attributeValue = rowModel.getElement(this.metadataProvider.getDataPosition(attributeColumnId));
            this.logger.debug("Adding dimension attribute column " + attributeColumnId + " called " + attributeColumnLabel + " value " + attributeValue);
            if (attributeValue != null) {
                response.addSeriesAttributes(attributeColumnLabel, attributeValue);
                continue;
            }
            this.logger.warn("Dimension attribute not found");
        }
        return response;
    }

    public Map<String, SeriesModel> getSeriesMap() {
        return this.seriesModelMap;
    }
}

