package org.gcube.datapublishing.sdmx.impl.repository.dao;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;

import lombok.Data;

import org.eclipse.persistence.annotations.Index;

@Data
@Entity(name = "Registration")
@Table(uniqueConstraints = @UniqueConstraint(columnNames = { "FlowID",
		"FlowAgencyID", "FlowVersion", "ProviderAgencyID", "ProviderID" }))
@NamedQueries({
		@NamedQuery(name = "Registration.findAll", query = "SELECT r FROM Registration AS r"),
		@NamedQuery(name = "Registration.findByFlowId", query = "SELECT r FROM Registration AS r WHERE r.flowId = :flowId"),
		@NamedQuery(name = "Registration.findByFlow", query = "SELECT r FROM Registration AS r WHERE r.flowAgencyId = :flowAgencyId AND r.flowId = :flowId AND r.flowVersion = :flowVersion"),
		@NamedQuery(name = "Registration.findRegistration", query = "SELECT r FROM Registration AS r WHERE r.flowAgencyId = :flowAgencyId AND r.flowId = :flowId AND r.flowVersion = :flowVersion AND r.providerAgencyId = :providerAgencyId AND r.providerId = :providerId")
		})
public class Registration {
	
	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	private Integer id;

	@Column(name = "TimeseriesID", nullable = false)
	String timeseriesId;
	
	@Column(name = "TimeseriesScope", nullable = true)
	String timeseriesScope;
	
	@Column(name = "RegistryScope", nullable = true)
	String registryScope;
	
	@Column(name = "FlowAgencyID", nullable = false)
	String flowAgencyId;
	
	@Column(name = "FlowID", nullable = false)
	@Index
	String flowId;
	
	@Column(name = "FlowVersion", nullable = false)
	String flowVersion;
	
	@Column(name= "ProviderAgencyID", nullable=false)
	String providerAgencyId;
	
	@Column(name = "ProviderID", nullable = false)
	String providerId;

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		Registration other = (Registration) obj;
		if (flowAgencyId == null) {
			if (other.flowAgencyId != null)
				return false;
		} else if (!flowAgencyId.equals(other.flowAgencyId))
			return false;
		if (flowId == null) {
			if (other.flowId != null)
				return false;
		} else if (!flowId.equals(other.flowId))
			return false;
		if (flowVersion == null) {
			if (other.flowVersion != null)
				return false;
		} else if (!flowVersion.equals(other.flowVersion))
			return false;
		if (providerAgencyId == null) {
			if (other.providerAgencyId != null)
				return false;
		} else if (!providerAgencyId.equals(other.providerAgencyId))
			return false;
		if (providerId == null) {
			if (other.providerId != null)
				return false;
		} else if (!providerId.equals(other.providerId))
			return false;
		if (registryScope == null) {
			if (other.registryScope != null)
				return false;
		} else if (!registryScope.equals(other.registryScope))
			return false;
		if (timeseriesId == null) {
			if (other.timeseriesId != null)
				return false;
		} else if (!timeseriesId.equals(other.timeseriesId))
			return false;
		if (timeseriesScope == null) {
			if (other.timeseriesScope != null)
				return false;
		} else if (!timeseriesScope.equals(other.timeseriesScope))
			return false;
		return true;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result
				+ ((flowAgencyId == null) ? 0 : flowAgencyId.hashCode());
		result = prime * result + ((flowId == null) ? 0 : flowId.hashCode());
		result = prime * result
				+ ((flowVersion == null) ? 0 : flowVersion.hashCode());
		result = prime
				* result
				+ ((providerAgencyId == null) ? 0 : providerAgencyId.hashCode());
		result = prime * result
				+ ((providerId == null) ? 0 : providerId.hashCode());
		result = prime * result
				+ ((registryScope == null) ? 0 : registryScope.hashCode());
		result = prime * result
				+ ((timeseriesId == null) ? 0 : timeseriesId.hashCode());
		result = prime * result
				+ ((timeseriesScope == null) ? 0 : timeseriesScope.hashCode());
		return result;
	}
	
	
	
}
