/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datapublishing.sdmx.rest;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.StreamingOutput;
import org.gcube.datapublishing.sdmx.api.repository.SDMXDataRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Path(value="data/{flowRef}/{key}/{providerRef}")
public class DataResource {
    @Autowired
    private SDMXDataRepository repository;

    @GET
    @Produces(value={"application/xml;version=2.1"})
    public StreamingOutput DataQuery(final @PathParam(value="flowRef") String flowRef, final @PathParam(value="key") @DefaultValue(value="all") String key, final @PathParam(value="providerRef") @DefaultValue(value="all") String providerRef, final @QueryParam(value="startPeriod") String startPeriod, final @QueryParam(value="endPeriod") String endPeriod, final @QueryParam(value="updatedAfter") String updatedAfter, final @QueryParam(value="firstNObservations") String firstNObservations, final @QueryParam(value="lastNObservations") String lastNObservations, final @QueryParam(value="dimensionAtObservation") String dimensionAtObservation, final @QueryParam(value="detail") @DefaultValue(value="full") String detail) {
        return new StreamingOutput(){

            public void write(OutputStream output) throws IOException, WebApplicationException {
                int b;
                InputStream is = DataResource.this.repository.dataQuery(flowRef, key, providerRef, startPeriod, endPeriod, updatedAfter, firstNObservations, lastNObservations, dimensionAtObservation, detail);
                while ((b = is.read()) != -1) {
                    output.write(b);
                }
            }
        };
    }
}

