package org.gcube.datapublishing.sdmx.rest;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.StreamingOutput;

import org.gcube.datapublishing.sdmx.api.repository.SDMXDataRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
//@Path("2.1/data/{flowRef}/{key}/{providerRef}")
@Path("data/{flowRef}/{key}/{providerRef}")
public class DataResource {
	
	@Autowired
	private SDMXDataRepository repository;
	
	@GET
//    @Produces({"application/vnd.sdmx.genericdata+xml;version=2.1", "application/vnd.sdmx.structurespecificdata+xml;version=2.1", "application/vnd.sdmx.generictimeseriesdata+xml;version=2.1", "application/vnd.sdmx.structurespecifictimeseriesdata+xml;version=2.1" })
	@Produces("application/xml;version=2.1")
    public StreamingOutput DataQuery(@PathParam("flowRef") final String flowRef, @PathParam("key") @DefaultValue("all") final String key, @PathParam("providerRef") @DefaultValue("all") final String  providerRef, @QueryParam("startPeriod") final String  startPeriod, 
                @QueryParam("endPeriod") final String endPeriod, @QueryParam("updatedAfter") final String updatedAfter, @QueryParam("firstNObservations") final String firstNObservations, @QueryParam("lastNObservations") final String  lastNObservations, 
                @QueryParam("dimensionAtObservation") final String dimensionAtObservation, @QueryParam("detail") @DefaultValue("full") final String detail){
		
		return new StreamingOutput() {
			
			@Override
			public void write(OutputStream output) throws IOException,
					WebApplicationException {
				InputStream is = repository.dataQuery(flowRef, key, providerRef, startPeriod, endPeriod, updatedAfter, firstNObservations, lastNObservations, dimensionAtObservation, detail);
				int b;
				while ((b = is.read()) != -1) output.write(b);
			}
		}; 
		
    }

}