package org.gcube.datapublishing.sdmx.api.timeseries;

import java.util.List;

public interface TimeSeriesServiceClient {
	
	public enum Detail{
		full("Return all data - default behavior"), 
		dataonly("Return series without attributes and observations attributes"),
		serieskeysonly("Return series codes only"),
		nodata("Return series without observations");
		
		String description;
		
		private Detail(String description) {
			this.description=description;
		}
		
		public String getDescription(){return description;}
		
	}
	
	public TimeSeries getTimeSeries(String timeseriesId, List<Code> codeFilter, int firstNObservations, Detail detail);

}
