/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.simulfishgrowthdata.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Scanner;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Entity;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class CalcKPIAlgorithmExecutor {
    private static final Logger logger = LoggerFactory.getLogger(CalcKPIAlgorithmExecutor.class);
    boolean ignoreWhitespace = false;
    boolean ignoreComments = false;
    boolean putCDATAIntoText = false;
    boolean createEntityRefs = false;
    static final String outputEncoding = "UTF-8";
    static final String formatQueryParam = "&%s=%s";
    static final String formatAlgorithmParam = "%s=%s;";
    static final String RESULT_TYPE = "OutputTable";
    String mIdentification;
    String mToken;
    String mParamDbName;
    String mParamUserName;
    String mParamUserPassword;
    String mParamDbHost;
    String mParamSimulModelId;
    String mEndpointName;
    private Exception exception;
    DOMEcho debugEcho;

    public CalcKPIAlgorithmExecutor(String endpointName, String identification, String token) {
        this.mEndpointName = endpointName;
        this.mIdentification = identification;
        this.mToken = token;
    }

    public CalcKPIAlgorithmExecutor setConnectionInfo(String dbName, String userName, String password, String host) {
        this.mParamDbName = dbName;
        this.mParamUserName = userName;
        this.mParamUserPassword = password;
        this.mParamDbHost = host;
        return this;
    }

    public CalcKPIAlgorithmExecutor setModelId(String id) {
        this.mParamSimulModelId = id;
        return this;
    }

    public void execute(String endPointUrl) throws Exception {
        this.debugEcho = new DOMEcho(new PrintWriter((Writer)new OutputStreamWriter((OutputStream)System.out, outputEncoding), true));
        this.processOutput(this.triggerAlgorithm(endPointUrl, this.mToken));
    }

    private String triggerAlgorithm(String urlEndPoint, String token) throws Exception {
        LinkedHashMap<String, String> algorithmParams = new LinkedHashMap<String, String>();
        algorithmParams.put("KPI.name.db", this.mParamDbName);
        algorithmParams.put("KPI.user.name", this.mParamUserName);
        algorithmParams.put("KPI.user.password", this.mParamUserPassword);
        algorithmParams.put("KPI.user.host", this.mParamDbHost);
        algorithmParams.put("KPI.simulmodel.id", this.mParamSimulModelId);
        StringBuilder algoParamsBuilder = new StringBuilder();
        for (Map.Entry entry : algorithmParams.entrySet()) {
            algoParamsBuilder.append(String.format(formatAlgorithmParam, entry.getKey(), entry.getValue()));
        }
        String uriString = urlEndPoint + "?" + String.format(formatQueryParam, "request", "Execute") + String.format(formatQueryParam, "service", "WPS") + String.format(formatQueryParam, "Version", "1.0.0") + String.format(formatQueryParam, "gcube-token", token) + String.format(formatQueryParam, "lang", "en-US") + String.format(formatQueryParam, "Identifier", this.mIdentification) + String.format(formatQueryParam, "DataInputs", URLEncoder.encode(algoParamsBuilder.toString(), outputEncoding));
        URI uri = URI.create(uriString);
        if (logger.isTraceEnabled()) {
            logger.trace(String.format("calling uri [%s]", uri));
        }
        String toRet = "";
        HttpGet request = new HttpGet(uri);
        request.addHeader("Accept", "application/xml");
        CloseableHttpClient httpclient = HttpClients.createDefault();
        CloseableHttpResponse resp = httpclient.execute((HttpUriRequest)request);
        toRet = this.getContents(resp);
        return toRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getContents(CloseableHttpResponse resp) throws Exception {
        String exceptionMessage;
        String str;
        block11: {
            str = "";
            exceptionMessage = null;
            try {
                HttpEntity entity;
                StatusLine statusLine = resp.getStatusLine();
                if (logger.isTraceEnabled()) {
                    logger.trace(String.format("status line is [%s]", statusLine));
                }
                if (statusLine.getStatusCode() != 200) {
                    exceptionMessage = "The server responded: " + statusLine.getReasonPhrase();
                }
                if ((entity = resp.getEntity()) == null) break block11;
                try (InputStream is = entity.getContent();){
                    Scanner s = new Scanner(is, StandardCharsets.UTF_8.name()).useDelimiter("\\A");
                    str = s.hasNext() ? s.next() : "";
                }
                if (logger.isTraceEnabled()) {
                    logger.trace(String.format("response is [%s]", str));
                }
            }
            finally {
                resp.close();
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.format("contentes ~~~%s~~~", str));
        }
        if (exceptionMessage != null) {
            throw new Exception(exceptionMessage, new Exception(str));
        }
        return str;
    }

    private void processOutput(String output) throws ParserConfigurationException, SAXException, IOException, Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setIgnoringComments(this.ignoreComments);
        dbf.setIgnoringElementContentWhitespace(this.ignoreWhitespace);
        dbf.setCoalescing(this.putCDATAIntoText);
        dbf.setExpandEntityReferences(!this.createEntityRefs);
        DocumentBuilder db = dbf.newDocumentBuilder();
        db.setErrorHandler(new MyErrorHandler(new PrintWriter((Writer)new OutputStreamWriter((OutputStream)System.err, outputEncoding), true)));
        ByteArrayInputStream asStream = new ByteArrayInputStream(output.getBytes(StandardCharsets.UTF_8));
        Document doc = db.parse(asStream);
        if (logger.isTraceEnabled()) {
            logger.trace(String.format("doc.getFirstChild().getNodeName() [%s]", doc.getFirstChild().getNodeName()));
            for (int i = 0; i < doc.getChildNodes().getLength(); ++i) {
                Node node = doc.getChildNodes().item(i);
                logger.trace(String.format("doc child at [%s] is [%s]", i, node.getNodeName()));
                if (!node.hasChildNodes()) continue;
                for (int j = 0; j < node.getChildNodes().getLength(); ++j) {
                    Node node2 = node.getChildNodes().item(j);
                    logger.trace(String.format("child at [%s] is [%s]", j, node2.getNodeName()));
                }
            }
        }
        this.processResponse(doc);
    }

    private void processResponse(Document doc) throws ParserConfigurationException, SAXException, IOException {
        ResultData resultData = this.retrieveResultData(doc);
        if (logger.isTraceEnabled()) {
            logger.trace(String.format("Result data ~~~%s~~~", resultData));
        }
    }

    private ResultData retrieveResultData(Document doc) {
        ResultData resultData = null;
        Node nodeOutput = this.findSubNode("wps:ProcessOutputs", doc.getFirstChild());
        if (logger.isTraceEnabled()) {
            logger.trace("wps:ProcessOutputs ===========================================");
        }
        this.debugEcho.echo(nodeOutput);
        if (nodeOutput != null) {
            Node nodeData = this.findSubNode("wps:ComplexData", nodeOutput, true);
            if (logger.isTraceEnabled()) {
                logger.trace("wps:ComplexData ===========================================");
            }
            this.debugEcho.echo(nodeData);
            if (nodeData != null) {
                resultData = new ResultData(nodeData.getAttributes().getNamedItem("mimeType").getTextContent(), nodeData.getTextContent());
            }
        }
        return resultData;
    }

    public Node findSubNode(String name, Node node, boolean recurse) {
        Node subnode;
        int i;
        if (node.getNodeType() != 1) {
            if (logger.isTraceEnabled()) {
                logger.trace("Error: Search node not of element type");
            }
            return null;
        }
        if (!node.hasChildNodes()) {
            return null;
        }
        NodeList list = node.getChildNodes();
        for (i = 0; i < list.getLength(); ++i) {
            subnode = list.item(i);
            if (subnode.getNodeType() != 1 || !subnode.getNodeName().equals(name)) continue;
            return subnode;
        }
        if (recurse) {
            list = node.getChildNodes();
            for (i = 0; i < list.getLength(); ++i) {
                subnode = list.item(i);
                Node found = null;
                found = this.findSubNode(name, subnode, true);
                if (found == null) continue;
                return found;
            }
        }
        return null;
    }

    public Node findSubNode(String name, Node node) {
        return this.findSubNode(name, node, false);
    }

    public static String getText(Node node) {
        StringBuffer result = new StringBuffer();
        if (!node.hasChildNodes()) {
            return "";
        }
        NodeList list = node.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node subnode = list.item(i);
            if (subnode.getNodeType() == 3) {
                result.append(subnode.getNodeValue());
                continue;
            }
            if (subnode.getNodeType() == 4) {
                result.append(subnode.getNodeValue());
                continue;
            }
            if (subnode.getNodeType() != 5) continue;
            result.append(CalcKPIAlgorithmExecutor.getText(subnode));
        }
        return result.toString();
    }

    public static void main(String[] args) throws Exception {
    }

    private static class DOMEcho {
        private int indent = 0;
        private final String basicIndent = " ";
        private PrintWriter out;

        public DOMEcho(PrintWriter out) {
            this.out = out;
        }

        private void echo(Node n) {
            if (n == null) {
                this.out.print("~~~ null node ~~~");
                return;
            }
            this.outputIndentation();
            short type = n.getNodeType();
            switch (type) {
                case 2: {
                    this.out.print("ATTR:");
                    this.printlnCommon(n);
                    break;
                }
                case 4: {
                    this.out.print("CDATA:");
                    this.printlnCommon(n);
                    break;
                }
                case 8: {
                    this.out.print("COMM:");
                    this.printlnCommon(n);
                    break;
                }
                case 11: {
                    this.out.print("DOC_FRAG:");
                    this.printlnCommon(n);
                    break;
                }
                case 9: {
                    this.out.print("DOC:");
                    this.printlnCommon(n);
                    break;
                }
                case 10: {
                    this.out.print("DOC_TYPE:");
                    this.printlnCommon(n);
                    NamedNodeMap nodeMap = ((DocumentType)n).getEntities();
                    this.indent += 2;
                    for (int i = 0; i < nodeMap.getLength(); ++i) {
                        Entity entity = (Entity)nodeMap.item(i);
                        this.echo(entity);
                    }
                    this.indent -= 2;
                    break;
                }
                case 1: {
                    this.out.print("ELEM:");
                    this.printlnCommon(n);
                    NamedNodeMap atts = n.getAttributes();
                    this.indent += 2;
                    for (int i = 0; i < atts.getLength(); ++i) {
                        Node att = atts.item(i);
                        this.echo(att);
                    }
                    this.indent -= 2;
                    break;
                }
                case 6: {
                    this.out.print("ENT:");
                    this.printlnCommon(n);
                    break;
                }
                case 5: {
                    this.out.print("ENT_REF:");
                    this.printlnCommon(n);
                    break;
                }
                case 12: {
                    this.out.print("NOTATION:");
                    this.printlnCommon(n);
                    break;
                }
                case 7: {
                    this.out.print("PROC_INST:");
                    this.printlnCommon(n);
                    break;
                }
                case 3: {
                    this.out.print("TEXT:");
                    this.printlnCommon(n);
                    break;
                }
                default: {
                    this.out.print("UNSUPPORTED NODE: " + type);
                    this.printlnCommon(n);
                }
            }
            ++this.indent;
            for (Node child = n.getFirstChild(); child != null; child = child.getNextSibling()) {
                this.echo(child);
            }
            --this.indent;
        }

        private void outputIndentation() {
            for (int i = 0; i < this.indent; ++i) {
                this.out.print(" ");
            }
        }

        private void printlnCommon(Node n) {
            this.out.print(" nodeName=\"" + n.getNodeName() + "\"");
            String val = n.getNamespaceURI();
            if (val != null) {
                this.out.print(" uri=\"" + val + "\"");
            }
            if ((val = n.getPrefix()) != null) {
                this.out.print(" pre=\"" + val + "\"");
            }
            if ((val = n.getLocalName()) != null) {
                this.out.print(" local=\"" + val + "\"");
            }
            if ((val = n.getNodeValue()) != null) {
                this.out.print(" nodeValue=");
                if (val.trim().equals("")) {
                    this.out.print("[WS]");
                } else {
                    this.out.print("\"" + n.getNodeValue() + "\"");
                }
            }
            this.out.println();
        }
    }

    private static class MyErrorHandler
    implements ErrorHandler {
        private PrintWriter out;

        MyErrorHandler(PrintWriter out) {
            this.out = out;
        }

        private String getParseExceptionInfo(SAXParseException spe) {
            String systemId = spe.getSystemId();
            if (systemId == null) {
                systemId = "null";
            }
            String info = "URI=" + systemId + " Line=" + spe.getLineNumber() + ": " + spe.getMessage();
            return info;
        }

        @Override
        public void warning(SAXParseException spe) throws SAXException {
            this.out.println("Warning: " + this.getParseExceptionInfo(spe));
        }

        @Override
        public void error(SAXParseException spe) throws SAXException {
            String message = "Error: " + this.getParseExceptionInfo(spe);
            throw new SAXException(message);
        }

        @Override
        public void fatalError(SAXParseException spe) throws SAXException {
            String message = "Fatal Error: " + this.getParseExceptionInfo(spe);
            throw new SAXException(message);
        }
    }

    static class ResultData {
        public String type;
        public String data;

        public ResultData(String type, String data) {
            this.type = type;
            this.data = data;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder().append("ResultData [ ").append(" type=").append(this.type).append(", data=").append(this.data).append("]");
            return builder.toString();
        }
    }
}

