/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.simulfishgrowthdata.api.base;

import com.google.common.base.Strings;
import gr.i2s.fishgrowth.model.Fcr;
import gr.i2s.fishgrowth.model.Modeler;
import gr.i2s.fishgrowth.model.Mortality;
import gr.i2s.fishgrowth.model.SampleData;
import gr.i2s.fishgrowth.model.Sfr;
import gr.i2s.fishgrowth.model.Sgr;
import gr.i2s.fishgrowth.model.TableEntity;
import gr.i2s.fishgrowth.model.Usage;
import gr.i2s.fishgrowth.model.WeightLimit;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.TreeMap;
import org.gcube.data.simulfishgrowthdata.api.base.BaseUtil;
import org.gcube.data.simulfishgrowthdata.api.base.FcrUtil;
import org.gcube.data.simulfishgrowthdata.api.base.MortalityUtil;
import org.gcube.data.simulfishgrowthdata.api.base.SfrUtil;
import org.gcube.data.simulfishgrowthdata.model.UnivariateOutlierDetector;
import org.gcube.data.simulfishgrowthdata.util.ExcelReader;
import org.gcube.data.simulfishgrowthdata.util.HibernateUtil;
import org.gcube.data.simulfishgrowthdata.util.UserFriendlyException;
import org.hibernate.Session;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.Query;
import org.hibernate.transform.Transformers;
import org.hibernate.type.DoubleType;
import org.hibernate.type.IntegerType;
import org.hibernate.type.LongType;
import org.hibernate.type.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelerUtil
extends BaseUtil {
    public static final Long STATUS_READY = 1L;
    public static final Long STATUS_PENDING_KPI = 2L;
    public static final Long STATUS_FAILED_KPI = 3L;
    private static final String _UPDATE_STATUS_ON_SITEID = "UPDATE SimulModel SET statusId=:statusId WHERE siteId = :siteId";
    private static final String _GET_GLOBAL = "FROM gr.i2s.fishgrowth.model.Modeler s WHERE s.designation = :designation AND s.ownerId = :ownerId";
    private static final String _GET_ALL_ON_OWNERID = "FROM gr.i2s.fishgrowth.model.Modeler s WHERE s.ownerId = :ownerid ORDER BY s.designation ASC";
    private static final String _GET_EXISTING_UPLOAD_SOURCE_SAMPLE = "SELECT DISTINCT uploadSource FROM gr.i2s.fishgrowth.model.SampleData s WHERE s.simulModelId = :simulModelId";
    private static final String _GET_EXISTING_UPLOAD_SOURCE_LIMITS = "SELECT DISTINCT uploadSource FROM gr.i2s.fishgrowth.model.WeightLimit s WHERE s.simulModelId = :simulModelId";
    private static final String _DELETE_ALL_SAMPLE_DATA = "DELETE FROM SampleData s WHERE s.simulModelId = :simulModelId";
    private static final String _DELETE_ALL_LIMITS_DATA = "DELETE FROM WeightLimit s WHERE s.simulModelId = :simulModelId";
    private static final String _GET_ALL_ON_SITE = "FROM gr.i2s.fishgrowth.model.Modeler s WHERE s.siteId = :siteid ORDER BY s.id ASC";
    private static final String _GET_ALL_IDS_ON_SITES = "SELECT id FROM SimulModel WHERE speciesId=:speciesId AND siteId IN (:siteids) ORDER BY id ASC";
    private static final String _GET_USAGE_ON_OWNERID = "SELECT us.id as id, us.scenariocount as usage FROM simulusageview us inner join simulmodel e on (us.id=e.id) WHERE e.ownerId = :ownerid ORDER BY us.id ASC";
    private static final String _GET_WEIGHT_LIMITS = "FROM gr.i2s.fishgrowth.model.WeightLimit s WHERE s.simulModelId = :simulModelId";
    private static final String _GET_COMMON_WEIGHT_LIMITS = "(SELECT DISTINCT :kindFcr AS \"kpiKind\", fromWeight AS \"fromWeight\" FROM fcr WHERE simulModelId IN (:modelIds) UNION SELECT DISTINCT :kindSfr AS \"kpiKind\", fromWeight AS \"fromWeight\" FROM sfr WHERE simulModelId IN (:modelIds) UNION SELECT DISTINCT :kindMortality AS \"kpiKind\", fromWeight AS \"fromWeight\" FROM mortality WHERE simulModelId IN (:modelIds)) ORDER BY \"kpiKind\", \"fromWeight\"";
    private static final String _GET_ALL_KPI_VALUES = "SELECT DISTINCT simulModelId AS \"simulModelId\", temperature AS \"temperature\", fromWeight AS \"fromWeight\", value AS \"value\" FROM :kpiTable WHERE simulModelId IN (:modelIds) ORDER BY simulModelId ASC, temperature ASC, fromWeight ASC";
    private static final String _GET_ALL_SAMPLE_DATA_ON_SIMULMODELID = "FROM gr.i2s.fishgrowth.model.SampleData s WHERE s.simulModelId = :simulModelId";
    private static final String _UPDATE_SAMPLE_DATA_OUTLIERS = "UPDATE SampleData s SET inclusion=:inclusion WHERE s.id in (:ids)";
    private static final Logger logger = LoggerFactory.getLogger(ModelerUtil.class);

    public Modeler add(Modeler modeler) throws Exception {
        return this.add(modeler, true);
    }

    public Modeler add(Modeler modeler, boolean createSamples) throws Exception {
        Session session = null;
        try {
            session = HibernateUtil.openSession();
            session.beginTransaction();
            this.add(session, modeler, createSamples);
            session.getTransaction().commit();
            Modeler modeler2 = modeler;
            return modeler2;
        }
        catch (Exception e) {
            logger.info(String.format("Could not add modeler [%s]", modeler), (Throwable)e);
            throw new Exception(String.format("Could not add modeler [%s]", modeler), e);
        }
        finally {
            HibernateUtil.closeSession(session);
        }
    }

    public Modeler add(Session session, Modeler modeler) throws Exception {
        return this.add(session, modeler, true);
    }

    public Modeler add(Session session, Modeler modeler, boolean createSamples) throws Exception {
        session.save((Object)modeler);
        if (createSamples) {
            this.manageUploadFiles(session, modeler);
        }
        Modeler global = this.globalBaseCopy(modeler);
        session.save((Object)global);
        session.flush();
        return modeler;
    }

    Modeler globalBaseCopy(Modeler copy) {
        Modeler toRet = new Modeler();
        toRet.setOwnerId("global");
        toRet.setDesignation(String.valueOf(copy.getId()));
        toRet.setSpeciesId(copy.getSpeciesId());
        toRet.setBroodstockQualityId(copy.getBroodstockQualityId());
        toRet.setBroodstockGeneticImprovement(copy.isBroodstockGeneticImprovement());
        toRet.setFeedQualityId(copy.getFeedQualityId());
        toRet.setStatusId(STATUS_FAILED_KPI.longValue());
        return toRet;
    }

    public Modeler update(Modeler modeler) throws Exception {
        return this.update(modeler, true);
    }

    public Modeler update(Modeler modeler, boolean createSamples) throws Exception {
        Session session = null;
        try {
            session = HibernateUtil.openSession();
            session.beginTransaction();
            this.update(session, modeler, createSamples);
            session.getTransaction().commit();
            Modeler modeler2 = modeler;
            return modeler2;
        }
        catch (Exception e) {
            logger.info(String.format("Could not update modeler [%s]", modeler), (Throwable)e);
            throw new Exception(String.format("Could not update modeler [%s]", modeler), e);
        }
        finally {
            HibernateUtil.closeSession(session);
        }
    }

    public Modeler update(Session session, Modeler modeler, boolean createSamples) throws Exception {
        session.update((Object)modeler);
        if (createSamples) {
            this.manageUploadFiles(session, modeler);
        }
        session.flush();
        return modeler;
    }

    public boolean delete(Long id) throws Exception {
        Session session = null;
        try {
            session = HibernateUtil.openSession();
            session.beginTransaction();
            Modeler modeler = this.getModeler(session, id);
            if (modeler != null && this.delete(session, modeler)) {
                session.flush();
            }
            session.getTransaction().commit();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            logger.info(String.format("Could not delete modeler [%s]", id), (Throwable)e);
            throw new Exception(String.format("Could not delete modeler [%s]", id), e);
        }
        finally {
            HibernateUtil.closeSession(session);
        }
    }

    static synchronized boolean isGlobal(Modeler modeler) {
        return "global".equalsIgnoreCase(modeler.getOwnerId());
    }

    public Modeler getModeler(Long id) throws Exception {
        Session session = null;
        try {
            session = HibernateUtil.openSession();
            session.beginTransaction();
            Modeler modeler = this.getModeler(session, id);
            session.getTransaction().commit();
            Modeler modeler2 = modeler;
            return modeler2;
        }
        catch (Exception e) {
            logger.info(String.format("Modeler not found [%s]", id), (Throwable)e);
            throw new Exception(String.format("Modeler not found [%s]", id), e);
        }
        finally {
            HibernateUtil.closeSession(session);
        }
    }

    public Modeler getModeler(Session session, Long id) throws Exception {
        Modeler modeler = (Modeler)session.get(Modeler.class, (Serializable)id);
        return modeler;
    }

    public List<Modeler> getModelers(String ownerId, List<Long> statuses) throws Exception {
        List list;
        Session session = null;
        try {
            logger.trace(String.format("start getModelers", new Object[0]));
            session = HibernateUtil.openSession();
            logger.trace(String.format("session [%s]", session));
            session.beginTransaction();
            Query q = session.createQuery(_GET_ALL_ON_OWNERID).setParameter("ownerid", (Object)ownerId);
            List list2 = q.list();
            if (statuses != null && !statuses.isEmpty()) {
                ListIterator iter = list2.listIterator();
                while (iter.hasNext()) {
                    Modeler m = (Modeler)iter.next();
                    if (statuses.contains(m.getStatusId())) continue;
                    iter.remove();
                }
            }
            session.getTransaction().commit();
            logger.trace(String.format("return Modelers %s", list2));
            list = list2;
        }
        catch (Exception e) {
            try {
                logger.info(String.format("Could not retrieve modelers for [%s]", ownerId), (Throwable)e);
                throw new Exception(String.format("Could not retrieve modelers for [%s]", ownerId), e);
            }
            catch (Throwable throwable) {
                HibernateUtil.closeSession(session);
                throw throwable;
            }
        }
        HibernateUtil.closeSession(session);
        return list;
    }

    public void cleanKPIs(Long id) throws Exception {
        if (logger.isTraceEnabled()) {
            logger.trace(String.format("cleaning KPIs for model %s", id));
        }
        Session session = null;
        try {
            session = HibernateUtil.openSession();
            logger.trace(String.format("session [%s]", session));
            session.beginTransaction();
            this.cleanKPIs(session, id);
            session.getTransaction().commit();
        }
        catch (Exception e) {
            logger.info(String.format("Could not clean KPIs for model [%s]", id), (Throwable)e);
            throw new Exception(String.format("Could not clean KPIs for model [%s]", id), e);
        }
        finally {
            HibernateUtil.closeSession(session);
        }
    }

    public void cleanKPIs(Session session, Long id) {
        new SfrUtil().deleteAll(session, id);
        new FcrUtil().deleteAll(session, id);
        new MortalityUtil().deleteAll(session, id);
    }

    private String importRemote(Session session, int kind, long id, String uploadFileType, String uploadFileLocation) throws Exception {
        if (kind == ExcelReader.KIND_SAMPLE) {
            String toRet = null;
            if (!Strings.isNullOrEmpty((String)uploadFileType) && ("xls".equalsIgnoreCase(uploadFileType) || "xlsx".equalsIgnoreCase(uploadFileType))) {
                ExcelReader.instance(ExcelReader.KIND_SAMPLE).importRemote(session, id, uploadFileLocation);
                toRet = uploadFileLocation;
            }
            if (toRet != null) {
                this.markOutliers(session, id);
                return toRet;
            }
            logger.error(String.format("uknown type [%s] for id [%s]", uploadFileType, id));
        } else if (kind == ExcelReader.KIND_LIMITS && !Strings.isNullOrEmpty((String)uploadFileType)) {
            if ("xls".equalsIgnoreCase(uploadFileType) || "xlsx".equalsIgnoreCase(uploadFileType)) {
                ExcelReader.instance(ExcelReader.KIND_LIMITS).importRemote(session, id, uploadFileLocation);
                return uploadFileLocation;
            }
            logger.error(String.format("uknown type [%s] for id [%s]", uploadFileType, id));
        }
        return null;
    }

    public String markOutliers(Session session, long modelid) throws Exception {
        SampleDatabase sampleDatabase;
        String toRet = "";
        Double lowerperc = 25.0;
        Double upperperc = 75.0;
        HashSet<Long> toMark = new HashSet<Long>();
        List<SampleData> samples = this.getSampleData(session, modelid);
        ArrayList<UnivariateOutlierDetector.IValue> mortality = new ArrayList<UnivariateOutlierDetector.IValue>();
        ArrayList<UnivariateOutlierDetector.IValue> sfr = new ArrayList<UnivariateOutlierDetector.IValue>();
        ArrayList<UnivariateOutlierDetector.IValue> fcr = new ArrayList<UnivariateOutlierDetector.IValue>();
        for (SampleData sampleData : samples) {
            mortality.add(new SampleDatabase(sampleData.getId(), sampleData.getMortalityRate()));
            sfr.add(new SampleDatabase(sampleData.getId(), sampleData.getSfr()));
            fcr.add(new SampleDatabase(sampleData.getId(), sampleData.getFcr()));
        }
        UnivariateOutlierDetector detector = new UnivariateOutlierDetector().addValues(mortality).defineLowerPercentage(lowerperc).defineUpperPercentage(upperperc).execute();
        detector.cleanFromOutliers();
        for (UnivariateOutlierDetector.IValue value : detector.getOutliers()) {
            sampleDatabase = (SampleDatabase)value;
            toMark.add(sampleDatabase.idx);
        }
        detector.cleanOutliers().cleanValues().addValues(sfr).execute().cleanFromOutliers();
        for (UnivariateOutlierDetector.IValue value : detector.getOutliers()) {
            sampleDatabase = (SampleDatabase)value;
            toMark.add(sampleDatabase.idx);
        }
        detector.cleanOutliers().cleanValues().addValues(fcr).execute().cleanFromOutliers();
        for (UnivariateOutlierDetector.IValue value : detector.getOutliers()) {
            sampleDatabase = (SampleDatabase)value;
            toMark.add(sampleDatabase.idx);
        }
        if (!toMark.isEmpty()) {
            NativeQuery nativeQuery = session.createSQLQuery(_UPDATE_SAMPLE_DATA_OUTLIERS);
            nativeQuery.setParameterList("ids", toMark);
            nativeQuery.setParameter("inclusion", (Object)0);
            nativeQuery.executeUpdate();
        }
        if (toMark.size() > samples.size() / 2) {
            toRet = String.format("Too many outliers (%.2f)", toMark.size() / samples.size());
        }
        return toRet;
    }

    private void manageUploadFiles(Session session, Modeler modeler) throws UserFriendlyException {
        try {
            this.manageUploadFile(session, modeler.getId(), ExcelReader.KIND_SAMPLE, modeler.getUploadFileTypeData(), modeler.getUploadFileLocationData());
        }
        catch (Exception e) {
            throw new UserFriendlyException("Could not upload SampleData file", e);
        }
        try {
            this.manageUploadFile(session, modeler.getId(), ExcelReader.KIND_LIMITS, modeler.getUploadFileTypeWeights(), modeler.getUploadFileLocationWeights());
        }
        catch (Exception e) {
            throw new UserFriendlyException("Could not upload WeightCategories file", e);
        }
    }

    private void manageUploadFile(Session session, long id, int kind, String type, String location) throws Exception {
        if (logger.isTraceEnabled()) {
            logger.trace(String.format("managing upload data file for [%s], of type [%s], located at [%s]", id, type, location));
        }
        String uploadData = Strings.nullToEmpty((String)location);
        String existingSQL = kind == ExcelReader.KIND_SAMPLE ? _GET_EXISTING_UPLOAD_SOURCE_SAMPLE : _GET_EXISTING_UPLOAD_SOURCE_LIMITS;
        Query qUploadSource = session.createQuery(existingSQL).setParameter("simulModelId", (Object)id);
        List existingUploadSource = qUploadSource.list();
        if (logger.isTraceEnabled()) {
            logger.trace(String.format("existing uploads for %s are [%s]", id, existingUploadSource));
        }
        if (!existingUploadSource.isEmpty()) {
            if (uploadData.equals(existingUploadSource.get(0))) {
                if (logger.isTraceEnabled()) {
                    logger.trace(String.format("upload data file for %s set to same value; bypassing", id));
                }
                return;
            }
            int recsCleaned = kind == ExcelReader.KIND_SAMPLE ? this.cleanSampleData(session, id) : this.cleanWeightLimits(session, id);
            if (logger.isTraceEnabled()) {
                logger.trace(String.format("upload data file for [%s] changed; erased [%s] mismatching records", id, recsCleaned));
            }
        }
        if (!Strings.isNullOrEmpty((String)uploadData)) {
            this.importRemote(session, kind, id, type, uploadData);
        }
    }

    public List<Modeler> getModelersForSite(Session session, Long siteid) {
        try {
            logger.trace(String.format("start getModelersForSites", new Object[0]));
            Query q = session.createQuery(_GET_ALL_ON_SITE).setParameter("siteid", (Object)siteid);
            List list = q.list();
            logger.trace(String.format("return Modelers %s", list));
            return list;
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Could not retrieve modelers for site [%s]", siteid), e);
        }
    }

    public List<Long> getModelerIdsForSites(Session session, Long speciesId, List<Long> siteids) {
        List<Long> toRet = new ArrayList<Long>();
        if (!siteids.isEmpty()) {
            try {
                logger.trace(String.format("start getModelersForSites", new Object[0]));
                NativeQuery q = session.createSQLQuery(_GET_ALL_IDS_ON_SITES).setParameterList("siteids", siteids).setParameter("speciesId", (Object)speciesId);
                toRet = q.list();
                logger.trace(String.format("return Modeler ids %s", toRet));
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("Could not retrieve modeler ids for sites [%s]", siteids), e);
            }
        }
        return toRet;
    }

    public List<WeightLimit> getWeightLimits(Session session, Long simulModelId) {
        try {
            logger.trace(String.format("start getModelersForSites", new Object[0]));
            Query q = session.createQuery(_GET_WEIGHT_LIMITS).setParameter("simulModelId", (Object)simulModelId);
            List list = q.list();
            logger.trace(String.format("return Modelers %s", list));
            return list;
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Could not retrieve modelers for site [%s]", simulModelId), e);
        }
    }

    public int cleanSampleData(Session session, Long id) {
        NativeQuery q = session.createSQLQuery(_DELETE_ALL_SAMPLE_DATA);
        q.setParameter("simulModelId", (Object)id);
        return q.executeUpdate();
    }

    public int cleanWeightLimits(Session session, Long id) {
        NativeQuery q = session.createSQLQuery(_DELETE_ALL_LIMITS_DATA);
        q.setParameter("simulModelId", (Object)id);
        return q.executeUpdate();
    }

    public boolean delete(Session session, Modeler modeler) {
        try {
            if (modeler == null) {
                return false;
            }
            if (!ModelerUtil.isGlobal(modeler)) {
                this.delete(session, this.getGlobal(session, modeler.getId()));
            }
            this.cleanSampleData(session, modeler.getId());
            this.cleanWeightLimits(session, modeler.getId());
            this.cleanKPIs(session, modeler.getId());
            session.delete((Object)modeler);
            return true;
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Could not delete Modeler  [%s]", modeler), e);
        }
    }

    public List<Usage> getUsage(String ownerId) throws Exception {
        List list;
        Session session = null;
        try {
            logger.trace(String.format("start getUsage", new Object[0]));
            session = HibernateUtil.openSession();
            logger.trace(String.format("session [%s]", session));
            session.beginTransaction();
            NativeQuery q = session.createSQLQuery(_GET_USAGE_ON_OWNERID).addEntity(Usage.class).setParameter("ownerid", (Object)ownerId);
            List list2 = q.list();
            session.getTransaction().commit();
            logger.trace(String.format("return site usage %s", list2));
            list = list2;
        }
        catch (Exception e) {
            try {
                logger.error(String.format("Could not retrieve site usage for ownerid [%s]", ownerId), (Throwable)e);
                throw new Exception(String.format("Could not retrieve site usage for ownerid [%s]", ownerId), e);
            }
            catch (Throwable throwable) {
                HibernateUtil.closeSession(session);
                throw throwable;
            }
        }
        HibernateUtil.closeSession(session);
        return list;
    }

    public Map<Integer, Collection<Double>> getCommonWeightLimits(Session session, Collection<Long> modelIds) throws Exception {
        try {
            Query q = session.createSQLQuery(_GET_COMMON_WEIGHT_LIMITS).addScalar("kpiKind", (Type)new IntegerType()).addScalar("fromWeight", (Type)new DoubleType()).setParameter("kindFcr", (Object)1).setParameter("kindSfr", (Object)2).setParameter("kindMortality", (Object)4).setParameterList("modelIds", modelIds).setResultTransformer(Transformers.aliasToBean(CommonWeightLimitsType.class));
            List listQuery = q.list();
            logger.trace(String.format("got from db commonWeightLimits %s", listQuery));
            HashMap<Integer, Collection<Double>> toRet = new HashMap<Integer, Collection<Double>>();
            Integer curKpiKind = Integer.MIN_VALUE;
            ArrayList<Double> weights = null;
            for (CommonWeightLimitsType item : listQuery) {
                Integer kpiKind = item.kpiKind;
                if (!kpiKind.equals(curKpiKind)) {
                    if (weights != null && !weights.isEmpty()) {
                        toRet.put(curKpiKind, weights);
                    }
                    curKpiKind = kpiKind;
                    weights = new ArrayList<Double>();
                }
                weights.add(item.fromWeight);
            }
            if (weights != null && !weights.isEmpty()) {
                toRet.put(curKpiKind, weights);
            }
            logger.trace(String.format("return commonWeightLimits %s", toRet));
            return toRet;
        }
        catch (Exception e) {
            logger.error(String.format("Could not getCommonWeightLimits for modelIds [%s]", modelIds), (Throwable)e);
            throw new Exception(String.format("Could not getCommonWeightLimits for modelIds [%s]", modelIds), e);
        }
    }

    public Collection getCommonKPIValues(Session session, Integer kpiKind, Collection<Double> commonWeightLimits, Collection<Long> modelIds) throws Exception {
        try {
            String kpiTableName;
            if (kpiKind == 1) {
                kpiTableName = "Fcr";
            } else if (kpiKind == 2) {
                kpiTableName = "Sfr";
            } else if (kpiKind == 3) {
                kpiTableName = "Sgr";
            } else if (kpiKind == 4) {
                kpiTableName = "Mortality";
            } else {
                throw new Exception(String.format("Unknown kpiKind [%s]", kpiKind));
            }
            long start = System.currentTimeMillis();
            Query q = session.createSQLQuery(_GET_ALL_KPI_VALUES.replace(":kpiTable", kpiTableName)).addScalar("simulModelId", (Type)new LongType()).addScalar("temperature", (Type)new IntegerType()).addScalar("fromWeight", (Type)new DoubleType()).addScalar("value", (Type)new DoubleType()).setParameterList("modelIds", modelIds).setResultTransformer(Transformers.aliasToBean(KPIValuesType.class));
            List listQuery = q.list();
            long end = System.currentTimeMillis();
            logger.trace("global model kpi retrieve  " + (end - start));
            logger.trace(String.format("got from db getCommonKPIValues %s", listQuery));
            start = System.currentTimeMillis();
            ArrayList<TableEntity> toRet = new ArrayList<TableEntity>();
            TreeMap simulModels = new TreeMap();
            Long curSimulModelId = Long.MIN_VALUE;
            Integer curTemperature = Integer.MIN_VALUE;
            TreeMap<Double, Double> values = null;
            TreeMap<Integer, Map<Double, Double>> temps = null;
            Iterator iterQuery = listQuery.iterator();
            while (iterQuery.hasNext()) {
                Map<Double, Double> expandedValues;
                Integer temperature;
                KPIValuesType item = (KPIValuesType)iterQuery.next();
                Long simulModelId = item.simulModelId;
                if (!simulModelId.equals(curSimulModelId)) {
                    if (values != null) {
                        Map<Double, Double> expandedValues2 = this.expandAccordingToCommonWeights(commonWeightLimits, values);
                        temps.put(curTemperature, expandedValues2);
                    }
                    temps = new TreeMap<Integer, Map<Double, Double>>();
                    curTemperature = Integer.MIN_VALUE;
                    values = null;
                    simulModels.put(simulModelId, temps);
                    curSimulModelId = simulModelId;
                }
                if (!(temperature = item.temperature).equals(curTemperature)) {
                    if (values != null) {
                        expandedValues = this.expandAccordingToCommonWeights(commonWeightLimits, values);
                        temps.put(curTemperature, expandedValues);
                    }
                    values = new TreeMap<Double, Double>();
                    temps.put(temperature, values);
                    curTemperature = temperature;
                }
                values.put(item.fromWeight, item.value);
                if (iterQuery.hasNext() || values == null) continue;
                expandedValues = this.expandAccordingToCommonWeights(commonWeightLimits, values);
                temps.put(curTemperature, expandedValues);
            }
            end = System.currentTimeMillis();
            if (logger.isTraceEnabled()) {
                logger.trace("global model kpi step 1  " + (end - start));
            }
            logger.trace(String.format("retrieved %s", simulModels));
            start = System.currentTimeMillis();
            for (int temperature = 0; temperature <= 50; ++temperature) {
                int countAdded = 0;
                for (Double weight : commonWeightLimits) {
                    Double sum = 0.0;
                    Integer count = 0;
                    for (Long simulModel : simulModels.keySet()) {
                        Double value;
                        Map values2 = (Map)((Map)simulModels.get(simulModel)).get(temperature);
                        if (values2 == null || (value = (Double)values2.get(weight)) == null) continue;
                        sum = sum + value;
                        Integer n = count;
                        Integer n2 = count = Integer.valueOf(count + 1);
                    }
                    if (count <= 0) continue;
                    TableEntity toAdd = this.createTableEntity(kpiKind);
                    toAdd.setTemperature(temperature);
                    toAdd.setFromWeight(weight.doubleValue());
                    toAdd.setValue(sum / (double)count.intValue());
                    toRet.add(toAdd);
                    ++countAdded;
                }
                logger.trace(String.format("for temperature [%s] I have [%s] KPIs of kind [%s]", temperature, countAdded, kpiKind));
            }
            end = System.currentTimeMillis();
            if (logger.isTraceEnabled()) {
                logger.trace("global model kpi step 2  " + (end - start));
            }
            logger.trace(String.format("return getCommonKPIValues %s", toRet));
            return toRet;
        }
        catch (Exception e) {
            logger.error(String.format("Could not getCommonKPIValues for modelIds [%s]", modelIds), (Throwable)e);
            throw new Exception(String.format("Could not getCommonKPIValues for modelIds [%s]", modelIds), e);
        }
    }

    TableEntity createTableEntity(int kpiKind) {
        if (kpiKind == 1) {
            return new Fcr();
        }
        if (kpiKind == 2) {
            return new Sfr();
        }
        if (kpiKind == 3) {
            return new Sgr();
        }
        if (kpiKind == 4) {
            return new Mortality();
        }
        throw new RuntimeException(String.format("Unknown kpiKind [%s]", kpiKind));
    }

    private Map<Double, Double> expandAccordingToCommonWeights(Collection<Double> commonWeightLimits, Map<Double, Double> values) {
        TreeMap<Double, Double> expandedValues = new TreeMap<Double, Double>();
        Double lastValue = null;
        for (Double weight : commonWeightLimits) {
            if (values.containsKey(weight)) {
                lastValue = values.get(weight);
            }
            expandedValues.put(weight, lastValue);
        }
        return expandedValues;
    }

    public int updateStatusOnSite(Session session, Long siteId, Long statusId) {
        NativeQuery q = session.createSQLQuery(_UPDATE_STATUS_ON_SITEID);
        q.setParameter("siteId", (Object)siteId);
        q.setParameter("statusId", (Object)statusId);
        return q.executeUpdate();
    }

    public Modeler getGlobal(Session session, Long id) {
        Modeler toRet = null;
        Query q = session.createQuery(_GET_GLOBAL).setParameter("designation", (Object)String.valueOf(id)).setParameter("ownerId", (Object)"global");
        List results = q.list();
        if (results != null && !results.isEmpty()) {
            toRet = (Modeler)results.get(0);
        }
        return toRet;
    }

    public List<SampleData> getSampleData(Session session, Long simulModelId) {
        Query q = session.createQuery(_GET_ALL_SAMPLE_DATA_ON_SIMULMODELID).setParameter("simulModelId", (Object)simulModelId);
        ArrayList toRet = q.list();
        if (toRet == null) {
            toRet = new ArrayList();
        }
        return toRet;
    }

    public static class KPIValuesType {
        Long simulModelId;
        Integer temperature;
        Double fromWeight;
        Double value;

        public Long getSimulModelId() {
            return this.simulModelId;
        }

        public void setSimulModelId(Long simulModelId) {
            this.simulModelId = simulModelId;
        }

        public Integer getTemperature() {
            return this.temperature;
        }

        public void setTemperature(Integer temperature) {
            this.temperature = temperature;
        }

        public Double getFromWeight() {
            return this.fromWeight;
        }

        public void setFromWeight(Double fromWeight) {
            this.fromWeight = fromWeight;
        }

        public Double getValue() {
            return this.value;
        }

        public void setValue(Double value) {
            this.value = value;
        }

        public KPIValuesType() {
        }

        public KPIValuesType(Long simulModelId, Integer temperature, Double fromWeight, Double value) {
            this.simulModelId = simulModelId;
            this.temperature = temperature;
            this.fromWeight = fromWeight;
            this.value = value;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("KPIValuesType [simulModelId=").append(this.simulModelId).append(", temperature=").append(this.temperature).append(", fromWeight=").append(this.fromWeight).append(", value=").append(this.value).append("]");
            return builder.toString();
        }
    }

    public static class CommonWeightLimitsType {
        Integer kpiKind;
        Double fromWeight;

        public Integer getKpiKind() {
            return this.kpiKind;
        }

        public void setKpiKind(Integer kpiKind) {
            this.kpiKind = kpiKind;
        }

        public Double getFromWeight() {
            return this.fromWeight;
        }

        public void setFromWeight(Double fromWeight) {
            this.fromWeight = fromWeight;
        }

        public CommonWeightLimitsType() {
        }

        public CommonWeightLimitsType(Integer kpiKind, Double fromWeight) {
            this.kpiKind = kpiKind;
            this.fromWeight = fromWeight;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("CommonWeightLimitsType [kpiKind=").append(this.kpiKind).append(", fromWeight=").append(this.fromWeight).append("]");
            return builder.toString();
        }
    }

    static class SampleDatabase
    extends UnivariateOutlierDetector.SimpleValue {
        Long idx;

        public SampleDatabase(Long idx, Double value) {
            super(value);
            this.idx = idx;
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("SampleValue at [").append(this.idx).append("] = [").append(this.value).append("]");
            return builder.toString();
        }
    }
}

