/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.simulfishgrowthdata.calc;

import com.google.common.base.MoreObjects;
import gr.i2s.fishgrowth.Simulator.Executor;
import gr.i2s.fishgrowth.model.Modeler;
import gr.i2s.fishgrowth.model.Scenario;
import java.text.SimpleDateFormat;
import java.util.Iterator;
import java.util.LinkedList;
import org.gcube.data.simulfishgrowthdata.api.base.ModelerUtil;
import org.gcube.data.simulfishgrowthdata.calc.GlobalModelScenarioExecutor;
import org.gcube.data.simulfishgrowthdata.calc.ScenarioExecutor;
import org.gcube.data.simulfishgrowthdata.model.GlobalModelWrapper;
import org.gcube.data.simulfishgrowthdata.util.UserFriendlyException;
import org.hibernate.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WhatIfAnalysisExecutor
extends ScenarioExecutor {
    public static final String GRAPH_SEPARATOR = "gri2sbbridge";
    private static final Logger logger = LoggerFactory.getLogger(WhatIfAnalysisExecutor.class);
    String additionalSimilarityConstraint = null;

    public WhatIfAnalysisExecutor setAdditionalSimilarityConstraint(String additionalSimilarityConstraint) {
        this.additionalSimilarityConstraint = additionalSimilarityConstraint;
        return this;
    }

    public WhatIfAnalysisExecutor(Scenario scenario) {
        super(scenario);
    }

    public WhatIfAnalysisExecutor(Session session, Scenario scenario) {
        super(session, scenario);
    }

    protected String processResults() {
        LinkedList<Executor.Daily> globalResults;
        Scenario globalScenario = new Scenario(this.mScenario);
        try {
            long start = System.currentTimeMillis();
            Modeler modeler = new ModelerUtil().getModeler(this.mSession, this.mScenario.getModelerId());
            GlobalModelWrapper globalModel = new GlobalModelWrapper(this.mSession, modeler).setAdditionalSimilarityConstraint(this.additionalSimilarityConstraint).create();
            globalScenario.setId(-1L);
            GlobalModelScenarioExecutor globalExecutor = new GlobalModelScenarioExecutor(this.mSession, globalScenario, globalModel);
            globalExecutor.setDoSave(false);
            globalExecutor.run();
            globalResults = globalExecutor.getResults();
            long end = System.currentTimeMillis();
            if (logger.isTraceEnabled()) {
                logger.trace(String.format("Global model creation %d", end - start));
            }
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.debug("Error processing analysis results", (Throwable)e);
            }
            throw new RuntimeException("Error processing analysis results", new UserFriendlyException("Could not process analysis data. There was an error estimating the Global Model.", e));
        }
        String fullResults = "[";
        fullResults = fullResults + String.format("{\"label\":\"%s\", \"value\": \"%.2f\", \"global\": \"%.2f\"},", "Average Weight", this.mScenario.getResultsWeight(), globalScenario.getResultsWeight());
        fullResults = fullResults + String.format("{\"label\":\"%s\", \"value\": \"%.2f\", \"global\": \"%.2f\"},", "LTD Growth", this.mScenario.getResultsGrowth(), globalScenario.getResultsGrowth());
        fullResults = fullResults + String.format("{\"label\":\"%s\", \"value\": \"%.2f\", \"global\": \"%.2f\"},", "LTD SGR", this.mScenario.getResultsSGR(), globalScenario.getResultsSGR());
        fullResults = fullResults + String.format("{\"label\":\"%s\", \"value\": \"%.2f\", \"global\": \"%.2f\"},", "LTD Biological FCR", this.mScenario.getResultsBiolFCR(), globalScenario.getResultsBiolFCR());
        fullResults = fullResults + String.format("{\"label\":\"%s\", \"value\": \"%.2f\", \"global\": \"%.2f\"},", "LTD Economical FCR", this.mScenario.getResultsEconFCR(), globalScenario.getResultsEconFCR());
        fullResults = fullResults + String.format("{\"label\":\"%s\", \"value\": \"%.2f\", \"global\": \"%.2f\"},", "LTD Mortality %", this.mScenario.getResultsMortality(), globalScenario.getResultsMortality());
        fullResults = fullResults + "]";
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yy");
        String tableWeight = new String();
        String tableFCR = new String();
        String tableFood = new String();
        String recordWeight = "{c:[{v: \"%s\"}, {v: %.2f}, {v: %.2f}]},";
        String recordFCR = "{c:[{v: \"%s\"}, {v: %.2f}, {v: %.2f}]},";
        String recordFood = "{c:[{v: \"%s-%s\"}, {v: %.2f}, {v: %.2f}]},";
        int foodMonth = -1;
        int foodYear = -1;
        double foodCons = 0.0;
        double foodConsGlobal = 0.0;
        Iterator globalIterator = globalResults.iterator();
        for (Executor.Daily daily : this.dailyResults) {
            Executor.Daily globalDaily = (Executor.Daily)globalIterator.next();
            String day = dateFormat.format(daily.date.getTime());
            tableWeight = tableWeight + String.format(recordWeight, day, daily.mab, globalDaily.mab);
            tableFCR = tableFCR + String.format(recordFCR, day, daily.fcr > 0.0 ? daily.fcr : 0.0, globalDaily.fcr > 0.0 ? globalDaily.fcr : 0.0);
            if (foodMonth != daily.date.get(2) || foodYear != daily.date.get(1)) {
                tableFood = tableFood + String.format(recordFood, foodMonth + 1, foodYear, foodCons > 0.0 ? foodCons / 1000.0 : 0.0, foodConsGlobal > 0.0 ? foodConsGlobal / 1000.0 : 0.0);
                foodCons = 0.0;
                foodConsGlobal = 0.0;
                foodMonth = daily.date.get(2);
                foodYear = daily.date.get(1);
            }
            foodCons += daily.food.doubleValue();
            foodConsGlobal += globalDaily.food.doubleValue();
        }
        if (foodCons > 0.0) {
            tableFood = tableFood + String.format(recordFood, foodMonth + 1, foodYear, foodCons / 1000.0, foodConsGlobal > 0.0 ? foodConsGlobal / 1000.0 : 0.0);
        }
        return fullResults + GRAPH_SEPARATOR + tableWeight + GRAPH_SEPARATOR + tableFCR + GRAPH_SEPARATOR + tableFood;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).toString();
    }
}

