package org.gcube.data.simulfishgrowthdata.calc;

import java.text.SimpleDateFormat;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.google.common.base.MoreObjects;

import gr.i2s.fishgrowth.model.Scenario;

/**
 * setup executorbased on a database scenario
 * 
 * @author bluebridge
 *
 */
public class ConsumptionScenarioExecutor extends ScenarioExecutor {
	private static final Logger logger = LoggerFactory.getLogger(ConsumptionScenarioExecutor.class);

	public ConsumptionScenarioExecutor(final Scenario scenario) {
		super(scenario);
		setDoSave(false);
		if (logger.isTraceEnabled())
			logger.trace(String.format("ctor"));

	}

	@Override
	protected String processResults() {
		if (logger.isTraceEnabled())
			logger.trace(String.format("processing results"));

		// Graphs
		SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/YY");
		String toRet = new String();
		String tableDaily = new String();
		String record = "{'day': '%s', 'bm':%s, 'fcre':%.2f, 'fcrb':%.2f, 'food':%s, 'bmdead':%s },";
		for (Daily daily : dailyResults) {
			String day = dateFormat.format(daily.date.getTime());
			String newDay = String.format(record, day, new Double(daily.fishcount * daily.mab).intValue(),
					daily.fcrEcon, daily.fcrBiol, Math.round(daily.food / 1000.0), daily.deadBM.intValue());
			if (logger.isTraceEnabled())
				logger.trace(String.format("adding day [%s]", newDay));

			tableDaily = tableDaily + newDay;
		}

		toRet = String.format("{'daily':[%s]}", tableDaily);

		if (logger.isTraceEnabled())
			logger.trace(String.format("after processing results returning [%s]", toRet));

		return toRet;
	}

	@Override
	public String toString() {
		return MoreObjects.toStringHelper(this).toString();
	}

}
