/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.simulfishgrowthdata.api;

import gr.i2s.fishgrowth.model.Mortality;
import java.util.List;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.gcube.data.simulfishgrowthdata.api.BaseUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/Mortality")
public class MortalityUtil
extends BaseUtil {
    private static final Logger logger = LoggerFactory.getLogger(MortalityUtil.class);

    @GET
    @Path(value="/all")
    public List<Mortality> getMortalities(@PathParam(value="modelId") Long modelId) throws Exception {
        try {
            return new org.gcube.data.simulfishgrowthdata.api.base.MortalityUtil().getMortalities(modelId);
        }
        catch (Exception e) {
            logger.error(String.format("Could not retrieve mortality for modelid [%s]", modelId), (Throwable)e);
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
    }

    @DELETE
    @Path(value="/{id}")
    public Response deleteAll(@PathParam(value="modelId") Long modelId) {
        try {
            int count = new org.gcube.data.simulfishgrowthdata.api.base.MortalityUtil().deleteAll(modelId);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)count).build();
        }
        catch (Exception e) {
            return Response.status((int)422).entity((Object)e).build();
        }
    }
}

