/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.simulfishgrowthdata.api;

import gr.i2s.fishgrowth.model.Scenario;
import gr.i2s.fishgrowth.model.ScenarioFull;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.gcube.data.simulfishgrowthdata.api.BaseUtil;
import org.gcube.data.simulfishgrowthdata.api.ScenarioUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/ScenarioFull")
public class ScenarioFullUtil
extends BaseUtil {
    private static final Logger logger = LoggerFactory.getLogger(ScenarioFullUtil.class);

    @PUT
    @Consumes(value={"application/json"})
    public Response add(ScenarioFull scenarioFull) throws Exception {
        return new ScenarioUtil().add(new Scenario((Scenario)scenarioFull));
    }

    @POST
    @Consumes(value={"application/json"})
    public Response update(ScenarioFull scenarioFull) throws Exception {
        return new ScenarioUtil().update(new Scenario((Scenario)scenarioFull));
    }

    @DELETE
    @Path(value="/{id}")
    public Response delete(@PathParam(value="id") Long id) throws Exception {
        return new ScenarioUtil().delete(id);
    }

    @GET
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    public ScenarioFull getScenarioFull(@PathParam(value="id") Long id) throws Exception {
        try {
            return new org.gcube.data.simulfishgrowthdata.api.base.ScenarioFullUtil().getScenarioFull(id);
        }
        catch (Exception e) {
            logger.error(String.format("Could not retrieve full scenario for [%s]", id), (Throwable)e);
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
    }

    @GET
    @Path(value="/all/{ownerId}/{start}/{end}")
    public List<ScenarioFull> getScenarioFulls(@PathParam(value="ownerId") String ownerId, @PathParam(value="start") Integer start, @PathParam(value="end") Integer end) throws Exception {
        try {
            return new org.gcube.data.simulfishgrowthdata.api.base.ScenarioFullUtil().getScenarioFulls(ownerId, start, end);
        }
        catch (Exception e) {
            logger.error(String.format("Could not retrieve full scenarios for ownerid[%s]", ownerId), (Throwable)e);
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
    }

    @GET
    @Path(value="/all/{ownerId}")
    public List<ScenarioFull> getScenarioFulls(@PathParam(value="ownerId") String ownerId) throws Exception {
        try {
            return new org.gcube.data.simulfishgrowthdata.api.base.ScenarioFullUtil().getScenarioFulls(ownerId);
        }
        catch (Exception e) {
            logger.error(String.format("Could not retrieve full scenarios for ownerid[%s]", ownerId), (Throwable)e);
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
    }

    @GET
    @Path(value="/count/{ownerId}")
    public int getScenarioFullCount(@PathParam(value="ownerId") String ownerId) throws Exception {
        try {
            return new org.gcube.data.simulfishgrowthdata.api.base.ScenarioFullUtil().getScenarioFullCount(ownerId);
        }
        catch (Exception e) {
            logger.error(String.format("Could not retrieve full scenario count for ownerid[%s]", ownerId), (Throwable)e);
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
    }

    @GET
    @Path(value="/execute/{id}")
    @Produces(value={"application/json"})
    public Scenario executeScenario(@PathParam(value="id") Long id) throws Exception {
        return new ScenarioUtil().executeScenario(id);
    }
}

