/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.simulfishgrowthdata.api;

import com.google.common.base.Joiner;
import gr.i2s.fishgrowth.model.Modeler;
import gr.i2s.fishgrowth.model.Usage;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.gcube.data.simulfishgrowthdata.api.BaseUtil;
import org.gcube.data.simulfishgrowthdata.util.UserFriendlyException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/Modeler")
public class ModelerUtil
extends BaseUtil {
    private static final Logger logger = LoggerFactory.getLogger(ModelerUtil.class);

    @PUT
    @Consumes(value={"application/json"})
    public Response add(Modeler modeler, @DefaultValue(value="1") @QueryParam(value="createSamples") Long createSamples) throws Exception {
        System.out.println("createSamples " + createSamples);
        try {
            modeler = new org.gcube.data.simulfishgrowthdata.api.base.ModelerUtil().add(modeler, createSamples != 0L);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)modeler.getId()).build();
        }
        catch (Exception e) {
            logger.error(String.format("Could not add modeler [%s]", modeler), (Throwable)e);
            return Response.status((int)422).entity((Object)Joiner.on((String)" ~ ").skipNulls().join((Iterable)UserFriendlyException.getFriendlyTraceFrom((Throwable)e))).build();
        }
    }

    @POST
    @Consumes(value={"application/json"})
    public Response update(Modeler modeler, @DefaultValue(value="1") @QueryParam(value="createSamples") Long createSamples) throws Exception {
        System.out.println("createSamples " + createSamples);
        try {
            modeler = new org.gcube.data.simulfishgrowthdata.api.base.ModelerUtil().update(modeler, createSamples != 0L);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)modeler).build();
        }
        catch (Exception e) {
            logger.error(String.format("Could not update modeler [%s]", modeler), (Throwable)e);
            return Response.status((int)422).entity((Object)Joiner.on((String)" ~ ").skipNulls().join((Iterable)UserFriendlyException.getFriendlyTraceFrom((Throwable)e))).build();
        }
    }

    @DELETE
    @Path(value="/{id}")
    public Response delete(@PathParam(value="id") Long id) throws Exception {
        try {
            new org.gcube.data.simulfishgrowthdata.api.base.ModelerUtil().delete(id);
            return Response.status((Response.Status)Response.Status.OK).build();
        }
        catch (Exception e) {
            logger.error(String.format("Could not delete modeler [%s]", id), (Throwable)e);
            return Response.status((int)422).entity((Object)e).build();
        }
    }

    @GET
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    public Modeler getModeler(@PathParam(value="id") Long id) throws Exception {
        try {
            return new org.gcube.data.simulfishgrowthdata.api.base.ModelerUtil().getModeler(id);
        }
        catch (Exception e) {
            logger.error(String.format("Could not retrieve modeler [%s]", id), (Throwable)e);
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
    }

    @GET
    @Path(value="/all/{ownerId}")
    public List<Modeler> getModelers(@PathParam(value="ownerId") String ownerId, @QueryParam(value="statuses") List<Long> statuses) throws Exception {
        try {
            return new org.gcube.data.simulfishgrowthdata.api.base.ModelerUtil().getModelers(ownerId, statuses);
        }
        catch (Exception e) {
            logger.error(String.format("Could not retrieve modelers for [%s]", ownerId), (Throwable)e);
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
    }

    @DELETE
    @Path(value="/kpi/{id}")
    public void cleanKPIs(@PathParam(value="id") Long id) {
        try {
            new org.gcube.data.simulfishgrowthdata.api.base.ModelerUtil().cleanKPIs(id);
        }
        catch (Exception e) {
            logger.error(String.format("Could not clean KPIs for model [%s]", id), (Throwable)e);
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
    }

    @GET
    @Path(value="/usage/{ownerId}")
    public List<Usage> getUsage(@PathParam(value="ownerId") String ownerId) throws Exception {
        try {
            return new org.gcube.data.simulfishgrowthdata.api.base.ModelerUtil().getUsage(ownerId);
        }
        catch (Exception e) {
            logger.error(String.format("Could not retrieve site usage for ownerid [%s]", ownerId), (Throwable)e);
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
    }
}

