/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.irmng;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.spd.irmng.Database;
import org.gcube.data.spd.irmng.Utils;
import org.gcube.data.spd.plugin.fwk.Properties;
import org.gcube.data.spd.plugin.fwk.Property;
import org.gcube.data.spd.plugin.fwk.capabilities.ClassificationCapability;
import org.gcube.data.spd.plugin.fwk.model.TaxonomyItem;
import org.gcube.data.spd.plugin.fwk.model.TaxonomyStatus;
import org.gcube.data.spd.plugin.fwk.writers.ObjectWriter;

public class ClassificationCapabilityImpl
extends ClassificationCapability {
    GCUBELog logger = new GCUBELog(ClassificationCapabilityImpl.class);

    public Set<Properties> getSupportedProperties() {
        return Collections.emptySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TaxonomyItem> retrieveTaxonChildsByTaxonId(String id_parent) {
        ArrayList<TaxonomyItem> list = new ArrayList<TaxonomyItem>();
        this.logger.trace((Object)("retrieveTaxonChildsByTaxonId " + id_parent));
        ResultSet results = null;
        Database database = null;
        String rank = "";
        String status = "";
        String citation = "";
        String syn_parent = "";
        String id = "";
        try {
            database = new Database();
            database.connect();
            this.logger.trace((Object)("select taxonrank, scientificnameauthorship, taxonomicstatus, modified, acceptednameusageid, taxonid from taxon where parentnameusageid = '" + id_parent + "'"));
            results = database.get("select taxonrank, scientificnameauthorship, taxonomicstatus, modified, acceptednameusageid, taxonid from taxon where parentnameusageid = '" + id_parent + "'");
            while (results.next()) {
                rank = results.getString(1);
                citation = results.getString(2);
                status = results.getString(3);
                Calendar modified = Utils.getCalendar(results.getString(4));
                syn_parent = results.getString(5);
                id = results.getString(6);
                TaxonomyItem item = new TaxonomyItem(id);
                item.setScientificName(Utils.setScName(id, rank));
                item.setCitation(citation);
                item.setRank(rank);
                item.setStatus(this.setStatusRI(status, syn_parent));
                item.setModified(modified);
                item.setParent(null);
                list.add(item);
            }
        }
        catch (SQLException sqlExcept) {
            this.logger.error((Object)"sql Error", (Throwable)sqlExcept);
        }
        catch (Throwable e) {
            this.logger.error((Object)"general Error", e);
        }
        finally {
            try {
                results.close();
            }
            catch (SQLException e) {
                this.logger.error((Object)"SQLException", (Throwable)e);
            }
            database.shutDown();
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TaxonomyItem createTaxonomy(String id_record) {
        TaxonomyItem t = null;
        ResultSet results = null;
        Database database = null;
        String status = "";
        String syn_parent = "";
        try {
            database = new Database();
            database.connect();
            results = database.get("select parentnameusageid, scientificname, taxonrank, scientificnameauthorship, taxonomicstatus, modified, acceptednameusageid from taxon where taxonid = '" + id_record + "'");
            if (results.next()) {
                String id_parent = results.getString(1);
                t = new TaxonomyItem(id_record + "");
                t.setScientificName(Utils.setScName(id_record, results.getString(3)));
                t.setRank(results.getString(3));
                t.setCitation(results.getString(4));
                syn_parent = results.getString(7);
                status = results.getString(5);
                t.setStatus(this.setStatusRI(status, syn_parent));
                Calendar modified = Utils.getCalendar(results.getString(6));
                t.setModified(modified);
                if (id_parent != null) {
                    t.setParent(this.createTaxonomy(id_parent));
                } else {
                    t.setParent(null);
                }
                results.close();
            } else {
                this.logger.trace((Object)("id " + id_record + " not in IRMNG"));
            }
        }
        catch (SQLException sqlExcept) {
            this.logger.error((Object)"sql Error", (Throwable)sqlExcept);
        }
        finally {
            try {
                results.close();
            }
            catch (SQLException e) {
                this.logger.error((Object)"sql Error", (Throwable)e);
            }
            database.shutDown();
        }
        return t;
    }

    private TaxonomyStatus setStatusRI(String status, String syn_parent) {
        TaxonomyStatus tax = null;
        tax = status != null ? (status.equals("accepted") ? new TaxonomyStatus("accepted", TaxonomyStatus.Status.ACCEPTED) : (status.equals("valid") ? new TaxonomyStatus("valid", TaxonomyStatus.Status.VALID) : (status.equals("synonym") ? new TaxonomyStatus(TaxonomyStatus.Status.SYNONYM, syn_parent, "synonym") : new TaxonomyStatus(status, TaxonomyStatus.Status.UNKNOWN)))) : new TaxonomyStatus(status, TaxonomyStatus.Status.UNKNOWN);
        return tax;
    }

    public void searchByCommonName(String name, ObjectWriter<TaxonomyItem> writer, Property ... arg2) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void searchByScientificName(String scientificName, ObjectWriter<TaxonomyItem> writer, Property ... arg2) {
        this.logger.trace((Object)("searchByScientificName " + scientificName));
        ResultSet results = null;
        Database database = null;
        String rank = "";
        String status = "";
        String citation = "";
        String syn_parent = "";
        String id = "";
        String id_parent = "";
        try {
            database = new Database();
            database.connect();
            results = database.get("select taxonrank, scientificnameauthorship, taxonomicstatus, modified, acceptednameusageid, taxonid, parentnameusageid from taxon where UPPER(scientificname) like UPPER('%" + scientificName + "%')");
            while (results.next()) {
                rank = results.getString(1);
                citation = results.getString(2);
                status = results.getString(3);
                Calendar modified = Utils.getCalendar(results.getString(4));
                syn_parent = results.getString(5);
                id = results.getString(6);
                id_parent = results.getString(7);
                TaxonomyItem item = new TaxonomyItem(id);
                item.setScientificName(Utils.setScName(id, rank));
                item.setCitation(citation);
                item.setRank(rank);
                item.setModified(modified);
                item.setStatus(this.setStatusRI(status, syn_parent));
                if (id_parent != null) {
                    item.setParent(this.createTaxonomy(id_parent));
                }
                writer.put((Object)item);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"ExceptionPrintStackTrace", (Throwable)e);
        }
        finally {
            writer.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void retrieveTaxonByIds(Iterator<String> ids, ObjectWriter<TaxonomyItem> writer) {
        block11: {
            block7: while (true) {
                try {
                    while (ids.hasNext()) {
                        String id = ids.next();
                        this.logger.trace((Object)("retrieveTaxonById " + id));
                        ResultSet results = null;
                        Database database = null;
                        String rank = "";
                        String status = "";
                        String citation = "";
                        String syn_parent = "";
                        String id_parent = "";
                        try {
                            database = new Database();
                            database.connect();
                            results = database.get("select taxonrank, scientificnameauthorship, taxonomicstatus, modified, acceptednameusageid, parentnameusageid from taxon where taxonid = '" + id + "'");
                            if (results.next()) {
                                rank = results.getString(1);
                                citation = results.getString(2);
                                status = results.getString(3);
                                Calendar modified = Utils.getCalendar(results.getString(4));
                                syn_parent = results.getString(5);
                                id_parent = results.getString(6);
                                TaxonomyItem item = new TaxonomyItem(id);
                                item.setScientificName(Utils.setScName(id, rank));
                                item.setCitation(citation);
                                item.setRank(rank);
                                item.setStatus(this.setStatusRI(status, syn_parent));
                                item.setModified(modified);
                                if (id_parent != null) {
                                    item.setParent(this.createTaxonomy(id_parent));
                                }
                                writer.put((Object)item);
                                continue block7;
                            }
                            this.logger.trace((Object)("id " + id + " not in IRMNG"));
                            continue block7;
                        }
                        catch (SQLException sqlExcept) {
                            this.logger.error((Object)"sql Error", (Throwable)sqlExcept);
                        }
                    }
                    break block11;
                }
                catch (Exception e) {
                    this.logger.error((Object)"ExceptionPrintStackTrace", (Throwable)e);
                    break block11;
                }
            }
            finally {
                writer.close();
            }
        }
    }
}

