/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.irmng;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.gcube.common.core.resources.GCUBERuntimeResource;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.spd.irmng.ClassificationCapabilityImpl;
import org.gcube.data.spd.irmng.CreateDBThread;
import org.gcube.data.spd.irmng.Database;
import org.gcube.data.spd.irmng.SynonimsCapabilityImpl;
import org.gcube.data.spd.irmng.UpdateThread;
import org.gcube.data.spd.irmng.Utils;
import org.gcube.data.spd.plugin.fwk.AbstractPlugin;
import org.gcube.data.spd.plugin.fwk.Capabilities;
import org.gcube.data.spd.plugin.fwk.Property;
import org.gcube.data.spd.plugin.fwk.SearchTypes;
import org.gcube.data.spd.plugin.fwk.capabilities.ClassificationCapability;
import org.gcube.data.spd.plugin.fwk.capabilities.SynonimsCapability;
import org.gcube.data.spd.plugin.fwk.model.DataProvider;
import org.gcube.data.spd.plugin.fwk.model.DataSet;
import org.gcube.data.spd.plugin.fwk.model.ResultItem;
import org.gcube.data.spd.plugin.fwk.writers.ObjectWriter;

public class IrmngPlugin
extends AbstractPlugin {
    private GCUBELog logger = new GCUBELog(IrmngPlugin.class);
    public static String hostName;
    public static String jdbc;
    public static String user;
    public static String password;
    static final String baseurl = "http://www.cmar.csiro.au/datacentre/downloads/IRMNG_DWC.zip";
    static final String credits = "IRMNG - Digital resource at http://www.obis.org.au/irmng/.";
    public static final String dumpDb = "/createIrmngDb.sql";

    public void initialize(GCUBERuntimeResource res) throws Exception {
        if (!this.SQLTableExists("Taxon") & !this.SQLTableExists("SpeciesProfile")) {
            new CreateDBThread();
        }
        new UpdateThread();
    }

    public void update(GCUBERuntimeResource res) throws Exception {
    }

    public Set<SearchTypes> getSupportedSearch() {
        return Collections.singleton(SearchTypes.ScientificName);
    }

    public Set<Capabilities> getSupportedCapabilities() {
        return new HashSet<Capabilities>(){
            {
                this.add(Capabilities.Classification);
                this.add(Capabilities.Synonims);
            }
        };
    }

    public ClassificationCapability getClassificationInterface() {
        return new ClassificationCapabilityImpl();
    }

    public SynonimsCapability getSynonimsInterface() {
        return new SynonimsCapabilityImpl();
    }

    public void searchByCommonName(String commonName, ObjectWriter<ResultItem> writer, Property ... properties) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void searchByScientificName(String scientificName, ObjectWriter<ResultItem> writer, Property ... properties) {
        this.logger.trace((Object)("searchByScientificName " + scientificName));
        ResultSet results = null;
        Database database = null;
        String id = "";
        String rank = "";
        String idParent = "";
        String citation = "";
        try {
            database = new Database();
            database.connect();
            this.logger.trace((Object)("select taxonid, taxonrank, parentnameusageid, scientificnameauthorship, nameaccordingto from taxon where UPPER(scientificname) like UPPER('%" + scientificName + "%')"));
            results = database.get("select taxonid, taxonrank, parentnameusageid, scientificnameauthorship, nameaccordingto from taxon where UPPER(scientificname) like UPPER('%" + scientificName + "%')");
            while (results.next()) {
                id = results.getString(1);
                rank = results.getString(2);
                idParent = results.getString(3);
                citation = results.getString(4);
                ResultItem item = new ResultItem(id, Utils.setScName(id, rank));
                item.setCitation(citation);
                item.setCredits(credits);
                item.setRank(rank);
                DataSet dataSet = new DataSet(results.getString(5));
                dataSet.setName(results.getString(5));
                dataSet.setCitation(results.getString(5));
                DataProvider dp = new DataProvider("irmngid");
                dp.setName("IRMNG");
                dataSet.setDataProvider(dp);
                item.setDataSet(dataSet);
                item.setParent(Utils.createTaxonomy(idParent));
                writer.put((Object)item);
            }
        }
        catch (SQLException sqlExcept) {
            this.logger.error((Object)"sql Error", (Throwable)sqlExcept);
        }
        catch (Throwable e) {
            this.logger.error((Object)"general Error", e);
        }
        finally {
            writer.close();
            try {
                results.close();
            }
            catch (SQLException e) {
                this.logger.error((Object)"general Error", (Throwable)e);
            }
            database.shutDown();
        }
    }

    public String getRepositoryName() {
        return "IRMNG";
    }

    public String getDescription() {
        return "Plugin for IRMNG";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean SQLTableExists(String tableName) {
        boolean exists = false;
        ResultSet rs = null;
        Database database = null;
        try {
            database = new Database();
            database.connect();
            String sqlText = "SELECT tables.table_name FROM information_schema.tables WHERE table_name = '" + tableName + "'";
            rs = database.get(sqlText);
            exists = rs.next();
        }
        catch (SQLException e) {
            this.logger.error((Object)"SQLException", (Throwable)e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException e) {
                this.logger.error((Object)"SQLException", (Throwable)e);
            }
            database.shutDown();
        }
        return exists;
    }
}

