/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.ncbi;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.spd.ncbi.Database;
import org.gcube.data.spd.ncbi.NcbiPlugin;
import org.gcube.data.spd.plugin.fwk.model.CommonName;
import org.gcube.data.spd.plugin.fwk.model.Taxon;

public class Utils {
    static GCUBELog logger = new GCUBELog(Utils.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createDB() throws SQLException, IOException {
        logger.trace((Object)"Creating tables...");
        Database database = null;
        try {
            String line;
            database = new Database();
            database.connect();
            BufferedReader br = new BufferedReader(new InputStreamReader(NcbiPlugin.class.getResourceAsStream("/ncbi_db.sql")));
            while ((line = br.readLine()) != null) {
                if (database.update(line)) continue;
                logger.warn((Object)("error in: '" + line + "'"));
            }
            logger.trace((Object)"Table created successfully");
        }
        finally {
            database.shutDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCitation(int id) {
        StringBuilder cit = new StringBuilder();
        ResultSet rs = null;
        ResultSet rs1 = null;
        Database database = null;
        try {
            database = new Database();
            database.connect();
            rs = database.get("select cit_id from citation where tax_id = " + id);
            while (rs.next()) {
                int cit_id = rs.getInt(1);
                rs1 = database.get("select cit_key from citations where cit_id = " + cit_id);
                while (rs1.next()) {
                    if (cit.length() != 0) {
                        cit.append(", ");
                    }
                    cit.append(rs1.getString(1));
                }
            }
        }
        catch (SQLException sqlExcept) {
            logger.error((Object)"sql Error", (Throwable)sqlExcept);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (rs1 != null) {
                    rs1.close();
                }
            }
            catch (SQLException e) {
                logger.error((Object)"SQLException", (Throwable)e);
            }
            database.shutDown();
        }
        return cit.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Taxon findTax(Integer id_record) {
        ResultSet rs = null;
        Taxon t = null;
        Database database = null;
        try {
            database = new Database();
            database.connect();
            rs = database.get("select a.parent_tax_id, b.name_txt, a.rank from nodes as a NATURAL JOIN names as b where a.tax_id = " + id_record + " and b.name_class = 'scientific name'");
            if (rs.next()) {
                int id_parent = rs.getInt(1);
                String rank = rs.getString(3);
                t = new Taxon(id_record + "");
                t.setRank(rank);
                t.setScientificName(rs.getString(2));
                t.setCitation(Utils.getCitation(id_record));
                if (id_parent != 1 && !rank.equals("kingdom")) {
                    t.setParent(Utils.findTax(id_parent));
                }
            }
        }
        catch (SQLException sqlExcept) {
            logger.error((Object)"sql Error", (Throwable)sqlExcept);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException e) {
                logger.error((Object)"SQLException", (Throwable)e);
            }
            database.shutDown();
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<CommonName> getCommonNames(int id) {
        ArrayList<CommonName> commonNames = new ArrayList<CommonName>();
        String language = "English";
        ResultSet rs = null;
        Database database = null;
        try {
            database = new Database();
            database.connect();
            rs = database.get("select name_txt from names where name_class = 'common name' and tax_id = " + id);
            while (rs.next()) {
                String name = rs.getString(1);
                CommonName a = new CommonName(language, name);
                commonNames.add(a);
            }
        }
        catch (SQLException sqlExcept) {
            logger.error((Object)"sql Error", (Throwable)sqlExcept);
        }
        catch (Throwable e) {
            logger.error((Object)"general Error", e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException e) {
                logger.error((Object)"SQLException", (Throwable)e);
            }
            database.shutDown();
        }
        return commonNames;
    }
}

