/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.ncbi;

import java.security.Key;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.utils.encryption.StringEncrypter;
import org.gcube.data.spd.model.Condition;
import org.gcube.data.spd.model.RepositoryInfo;
import org.gcube.data.spd.model.products.DataProvider;
import org.gcube.data.spd.model.products.DataSet;
import org.gcube.data.spd.model.products.ResultItem;
import org.gcube.data.spd.model.products.Taxon;
import org.gcube.data.spd.model.util.Capabilities;
import org.gcube.data.spd.model.util.ElementProperty;
import org.gcube.data.spd.ncbi.Utils;
import org.gcube.data.spd.ncbi.capabilities.ClassificationCapabilityImpl;
import org.gcube.data.spd.ncbi.capabilities.ExpansionCapabilityImpl;
import org.gcube.data.spd.ncbi.capabilities.NamesMappingImpl;
import org.gcube.data.spd.ncbi.connection.ConnectionPool;
import org.gcube.data.spd.ncbi.connection.ConnectionPoolException;
import org.gcube.data.spd.plugin.fwk.AbstractPlugin;
import org.gcube.data.spd.plugin.fwk.capabilities.ClassificationCapability;
import org.gcube.data.spd.plugin.fwk.capabilities.ExpansionCapability;
import org.gcube.data.spd.plugin.fwk.capabilities.MappingCapability;
import org.gcube.data.spd.plugin.fwk.writers.ObjectWriter;

public class NcbiPlugin
extends AbstractPlugin {
    static GCUBELog logger = new GCUBELog(NcbiPlugin.class);
    public static String dbDriver = "org.postgresql.Driver";
    public static String sqlfile = "/test.sql";
    public static String jdbc;
    public static String username;
    public static String password;
    public static String urlDump;
    public static final String credits = "This information object has been generated via the Species Product Discovery service on XDATEX by interfacing with The National Center for Biotechnology Information (http://www.ncbi.nlm.nih.gov/)";
    public static final String citation = "Accessed through: The National Center for Biotechnology Information at http://www.ncbi.nlm.nih.gov/ on ";
    static final String zipFileName = "taxdump.tar.gz";
    static final String fileDump = "/ncbi_db.sql";
    static final String[] names;
    static final String[] tables;

    public void initialize(ServiceEndpoint res) throws Exception {
        this.setUseCache(true);
        for (ServiceEndpoint.AccessPoint ap : res.profile().accessPoints()) {
            if (ap.name().equals("ftp")) {
                urlDump = ap.address();
                continue;
            }
            if (!ap.name().equals("jdbc")) continue;
            jdbc = ap.address();
            username = ap.username();
            password = StringEncrypter.getEncrypter().decrypt(ap.password(), new Key[0]);
        }
    }

    public void update(ServiceEndpoint res) throws Exception {
        for (ServiceEndpoint.AccessPoint ap : res.profile().accessPoints()) {
            if (ap.name().equals("ftp")) {
                urlDump = ap.address();
                continue;
            }
            if (!ap.name().equals("jdbc")) continue;
            jdbc = ap.address();
            username = ap.username();
            password = ap.password();
        }
        super.update(res);
    }

    public String getDescription() {
        return "NCBI Plugin";
    }

    public String getRepositoryName() {
        return "NCBI";
    }

    public Set<Capabilities> getSupportedCapabilities() {
        return new HashSet<Capabilities>(){
            {
                this.add(Capabilities.Classification);
                this.add(Capabilities.NamesMapping);
            }
        };
    }

    public ClassificationCapability getClassificationInterface() {
        return new ClassificationCapabilityImpl();
    }

    public MappingCapability getMappingInterface() {
        return new NamesMappingImpl();
    }

    public ExpansionCapability getSynonymCapability() {
        return new ExpansionCapabilityImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void searchByScientificName(String word, ObjectWriter<ResultItem> writer, Condition ... properties) {
        block43: {
            logger.trace((Object)("searchByScientificName for " + word + " in NCBI..."));
            ResultSet rs1 = null;
            ResultSet rs2 = null;
            ConnectionPool pool = null;
            Connection con = null;
            try {
                rs1 = Utils.getListScientificNameID(word);
                if (rs1 == null) break block43;
                while (rs1.next()) {
                    String id = rs1.getString(1);
                    pool = ConnectionPool.getConnectionPool();
                    con = pool.getConnection();
                    Statement statement = con.createStatement();
                    try {
                        rs2 = statement.executeQuery("select b.name_txt, a.rank, a.parent_tax_id from nodes as a NATURAL JOIN names as b where b.name_class = 'scientific name' and a.tax_id =" + id);
                        if (rs2.next()) {
                            String ScName = rs2.getString(1);
                            String rank = rs2.getString(2);
                            String idParent = rs2.getString(3);
                            ResultItem rs = new ResultItem(id, ScName);
                            rs.setCommonNames(Utils.getCommonNames(id));
                            Calendar now = Calendar.getInstance();
                            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
                            rs.setCredits(credits.replace("XDATEX", format.format(now.getTime())));
                            rs.setCitation(citation.replace("XDATEX", format.format(now.getTime())));
                            rs.setAuthor(Utils.setAuthorship(id, ScName));
                            if (rank.equals("no rank")) {
                                rs.setRank(null);
                            } else {
                                rs.setRank(rank);
                            }
                            List<String> citation = Utils.getCitation(idParent);
                            for (String c : citation) {
                                ElementProperty property = new ElementProperty("Comments and References", c);
                                rs.addProperty(property);
                            }
                            DataSet dataSet = new DataSet("GenBank");
                            dataSet.setName("GenBank taxonomy database");
                            DataProvider dp = new DataProvider("GenBank");
                            dp.setName("GenBank taxonomy database");
                            dataSet.setDataProvider(dp);
                            rs.setDataSet(dataSet);
                            if (!idParent.equals("1")) {
                                rs.setParent(NcbiPlugin.findTax(idParent));
                            }
                            if (!writer.isAlive()) break;
                            writer.write((Object)rs);
                        }
                        logger.trace((Object)("searchByCommonName finished for " + word + " in NCBI"));
                    }
                    catch (SQLException sqlExcept) {
                        logger.error((Object)"sql Error", (Throwable)sqlExcept);
                    }
                    finally {
                        if (pool != null && con != null) {
                            pool.releaseConnection(con);
                        }
                        try {
                            if (rs2 == null) continue;
                            rs2.close();
                        }
                        catch (SQLException ex) {
                            logger.error((Object)"sql Error", (Throwable)ex);
                        }
                        catch (Exception e) {
                            logger.error((Object)"General Error", (Throwable)e);
                        }
                    }
                }
            }
            catch (ConnectionPoolException e) {
                logger.error((Object)"ConnectionPoolException", (Throwable)e);
            }
            catch (SQLException e) {
                logger.error((Object)"SQLException", (Throwable)e);
            }
            finally {
                try {
                    if (rs1 != null) {
                        rs1.close();
                    }
                }
                catch (SQLException e) {
                    logger.error((Object)"sql Error", (Throwable)e);
                }
            }
        }
    }

    public RepositoryInfo getRepositoryInfo() {
        RepositoryInfo info = new RepositoryInfo("http://static.pubmed.gov/portal/portal3rc.fcgi/3417851/img/3242381", "http://www.ncbi.nlm.nih.gov/", "The National Center for Biotechnology Information advances science and health by providing access to biomedical and genomic information.The NCBI Taxonomy contains the names and phylogenetic lineages of more than 160,000 organisms that have molecular data in the NCBI databases. New taxa are added to the Taxonomy database as data are deposited for them.");
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Taxon findTax(String id_record) {
        String id = null;
        try {
            id = Utils.getOriginalId(id_record);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            id = id_record;
        }
        Taxon t = null;
        ConnectionPool pool = null;
        Connection con = null;
        try {
            pool = ConnectionPool.getConnectionPool();
            con = pool.getConnection();
            Statement statement = con.createStatement();
            ResultSet rs = statement.executeQuery("select a.parent_tax_id, b.name_txt, a.rank from nodes as a NATURAL JOIN names as b where a.tax_id = " + id + " and b.name_class = 'scientific name'");
            if (rs != null) {
                if (rs.next()) {
                    String id_parent = rs.getString(1);
                    String rank = rs.getString(3);
                    t = new Taxon(id + "");
                    t.setRank(rank);
                    t.setScientificName(rs.getString(2));
                    if (id_parent != "1" && !rank.equals("kingdom")) {
                        t.setParent(NcbiPlugin.findTax(id_parent));
                    }
                }
                rs.close();
            }
        }
        catch (SQLException sqlExcept) {
            logger.error((Object)"sql Error", (Throwable)sqlExcept);
        }
        catch (ConnectionPoolException e) {
            logger.error((Object)"ConnectionPoolException", (Throwable)e);
        }
        finally {
            if (pool != null && con != null) {
                pool.releaseConnection(con);
            }
        }
        return t;
    }

    static {
        names = new String[]{"nodes", "delnodes", "merged", "citations", "names", "division", "gencode"};
        tables = new String[]{"nodes", "delnodes", "merged", "citations", "names", "division", "gencode", "citation", "updates"};
    }
}

