/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.obisplugin.pool;

import java.util.Enumeration;
import java.util.Hashtable;
import org.gcube.common.core.utils.logging.GCUBELog;

public abstract class ObjectPool<T> {
    protected static GCUBELog logger = new GCUBELog(ObjectPool.class);
    protected long expirationTime;
    protected Hashtable<T, Long> locked;
    protected Hashtable<T, Long> unlocked;
    protected boolean closed = false;
    protected String name;

    public ObjectPool(String name, long expirationTime) {
        this.name = name;
        this.expirationTime = expirationTime;
        this.locked = new Hashtable();
        this.unlocked = new Hashtable();
    }

    protected abstract T create();

    protected abstract boolean validate(T var1);

    protected abstract void expire(T var1);

    public synchronized T checkOut() {
        T t;
        long now = System.currentTimeMillis();
        if (this.unlocked.size() > 0) {
            Enumeration<T> e = this.unlocked.keys();
            while (e.hasMoreElements()) {
                t = e.nextElement();
                if (now - this.unlocked.get(t) > this.expirationTime) {
                    this.unlocked.remove(t);
                    this.expire(t);
                    t = null;
                    continue;
                }
                if (this.validate(t)) {
                    this.unlocked.remove(t);
                    this.locked.put(t, now);
                    return t;
                }
                this.unlocked.remove(t);
                this.expire(t);
                t = null;
            }
        }
        logger.trace((Object)("no objects available, create a new one, status: " + this));
        t = this.create();
        this.locked.put(t, now);
        return t;
    }

    public synchronized void checkIn(T t) {
        this.locked.remove(t);
        if (!this.closed) {
            this.unlocked.put(t, System.currentTimeMillis());
        } else {
            this.expire(t);
        }
        logger.trace((Object)("pool status: " + this));
    }

    public synchronized void shutdown(boolean force) {
        this.closed = true;
        this.expireAllUnlocked();
        if (force) {
            this.expireAllLocked();
        }
    }

    public synchronized void expireAllUnlocked() {
        Enumeration<T> e = this.unlocked.keys();
        while (e.hasMoreElements()) {
            T t = e.nextElement();
            this.unlocked.remove(t);
            this.expire(t);
        }
    }

    public synchronized void expireAllLocked() {
        Enumeration<T> e = this.locked.keys();
        while (e.hasMoreElements()) {
            T t = e.nextElement();
            this.locked.remove(t);
            this.expire(t);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ObjectPool [name=");
        builder.append(this.name);
        builder.append(", expirationTime=");
        builder.append(this.expirationTime);
        builder.append(", locked=");
        builder.append(this.locked.size());
        builder.append(", unlocked=");
        builder.append(this.unlocked.size());
        builder.append(", closed=");
        builder.append(this.closed);
        builder.append("]");
        return builder.toString();
    }
}

