/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.obisplugin.search;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import org.gcube.data.spd.model.BasisOfRecord;
import org.gcube.data.spd.model.Condition;
import org.gcube.data.spd.model.exceptions.StreamBlockingException;
import org.gcube.data.spd.model.exceptions.StreamException;
import org.gcube.data.spd.model.products.DataSet;
import org.gcube.data.spd.model.products.OccurrencePoint;
import org.gcube.data.spd.obisplugin.search.DataSetRetreiver;
import org.gcube.data.spd.obisplugin.search.ProductKey;
import org.gcube.data.spd.obisplugin.search.Utils;
import org.gcube.data.spd.obisplugin.search.query.MappingUtils;
import org.gcube.data.spd.obisplugin.search.query.PagedQueryIterator;
import org.gcube.data.spd.obisplugin.search.query.PagedQueryObject;
import org.gcube.data.spd.obisplugin.search.query.QueryByIdentifier;
import org.gcube.data.spd.obisplugin.search.query.QueryCondition;
import org.gcube.data.spd.obisplugin.search.query.QueryType;
import org.gcube.data.spd.obisplugin.search.query.ResultType;
import org.gcube.data.spd.plugin.fwk.writers.ObjectWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OccurrenceSearch {
    private static Logger log = LoggerFactory.getLogger(OccurrenceSearch.class);
    private String baseURL;
    private final SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");

    public OccurrenceSearch(String baseURL) {
        this.baseURL = baseURL;
    }

    public void search(ObjectWriter<OccurrencePoint> writer, String scientificName, int limit, Condition ... conditions) throws Exception {
        PagedQueryObject occurrencesQuery = new PagedQueryObject(this.baseURL, ResultType.Occurrence, limit);
        List<QueryCondition> queryConditions = Utils.elaborateConditions(conditions);
        occurrencesQuery.setConditions(QueryCondition.cond("scientificname", scientificName.replaceAll(" ", "%20")));
        occurrencesQuery.getConditions().addAll(queryConditions);
        this.writeElements(writer, occurrencesQuery);
    }

    public void searchByKey(ObjectWriter<OccurrencePoint> writer, String key, int limit) throws Exception {
        PagedQueryObject occurrencesQuery = new PagedQueryObject(this.baseURL, ResultType.Occurrence, limit);
        ProductKey productKey = Utils.elaborateProductsKey(key);
        occurrencesQuery.getConditions().addAll(productKey.getQueryCondition());
        this.writeElements(writer, occurrencesQuery);
    }

    private void writeElements(ObjectWriter<OccurrencePoint> writer, PagedQueryObject occurrencesQuery) {
        PagedQueryIterator<OccurrencePoint> pagedIterator = new PagedQueryIterator<OccurrencePoint>(occurrencesQuery){

            @Override
            protected OccurrencePoint getObject(Map<String, Object> mappedObject) throws Exception {
                OccurrencePoint op = OccurrenceSearch.this.retrieveElement(mappedObject);
                Calendar now = Calendar.getInstance();
                String credits = "Biodiversity occurrence data accessed through OBIS WebService, http://api.iobis.org/, " + OccurrenceSearch.this.format.format(now.getTime()) + ")";
                op.setCredits(credits);
                return op;
            }
        };
        try {
            while (pagedIterator.hasNext() && writer.isAlive()) {
                writer.write(pagedIterator.next());
            }
        }
        catch (Exception e) {
            log.error("error writing occurrences", (Throwable)e);
            writer.write((StreamException)new StreamBlockingException("OBIS"));
        }
    }

    public OccurrencePoint searchById(String id) throws Exception {
        QueryByIdentifier queryByIdentifier = new QueryByIdentifier(this.baseURL, id, QueryType.Occurrence);
        return this.retrieveElement(MappingUtils.getObjectMapping(queryByIdentifier.build()));
    }

    private OccurrencePoint retrieveElement(Map<String, Object> mappedObj) throws Exception {
        long start = System.currentTimeMillis();
        String occurrenceId = MappingUtils.getAsString(mappedObj, "id");
        OccurrencePoint occurrence = new OccurrencePoint(occurrenceId);
        occurrence.setScientificNameAuthorship(MappingUtils.getAsString(mappedObj, "scientificNameAuthorship"));
        occurrence.setScientificName(MappingUtils.getAsString(mappedObj, "scientificName"));
        occurrence.setIdentifiedBy(MappingUtils.getAsString(mappedObj, "scientificNameID"));
        occurrence.setDecimalLatitude(MappingUtils.getAsDouble(mappedObj, "decimalLatitude").doubleValue());
        occurrence.setDecimalLongitude(MappingUtils.getAsDouble(mappedObj, "decimalLongitude").doubleValue());
        occurrence.setCoordinateUncertaintyInMeters(MappingUtils.getAsString(mappedObj, "coordinatePrecision"));
        Calendar eventDate = MappingUtils.getAsCalendar(mappedObj, "eventDate");
        occurrence.setEventDate(eventDate);
        occurrence.setCollectionCode(MappingUtils.getAsString(mappedObj, "collectionCode"));
        occurrence.setInstitutionCode(MappingUtils.getAsString(mappedObj, "institutionCode"));
        occurrence.setCatalogueNumber(MappingUtils.getAsString(mappedObj, "catalogNumber"));
        occurrence.setRecordedBy(MappingUtils.getAsString(mappedObj, "recordedBy"));
        occurrence.setCredits(MappingUtils.getAsString(mappedObj, "credits"));
        occurrence.setCountry(MappingUtils.getAsString(mappedObj, "country"));
        occurrence.setLocality(MappingUtils.getAsString(mappedObj, "locality"));
        occurrence.setBasisOfRecord(this.getBasisOfRecord(MappingUtils.getAsString(mappedObj, "basisOfRecord")));
        occurrence.setMinDepth(MappingUtils.getAsDouble(mappedObj, "minimumDepthInMeters").doubleValue());
        occurrence.setMaxDepth(MappingUtils.getAsDouble(mappedObj, "maximumDepthInMeters").doubleValue());
        occurrence.setKingdom(MappingUtils.getAsString(mappedObj, "kingdom"));
        occurrence.setFamily(MappingUtils.getAsString(mappedObj, "family"));
        String datasetId = MappingUtils.getAsString(mappedObj, "dataset_id");
        DataSet dataset = DataSetRetreiver.get(this.baseURL, datasetId);
        occurrence.setDataSet(dataset);
        occurrence.setProvider(dataset.getDataProvider().getName());
        log.trace("[Benchmark] time to retrieve occurrence is " + (System.currentTimeMillis() - start));
        return occurrence;
    }

    private BasisOfRecord getBasisOfRecord(String basisOfRecord) {
        if (basisOfRecord == null || basisOfRecord.isEmpty()) {
            return BasisOfRecord.Unknown;
        }
        switch (basisOfRecord) {
            case "PreservedSpecimen": {
                return BasisOfRecord.PreservedSpecimen;
            }
            case "FossilSpecimen": {
                return BasisOfRecord.FossilSpecimen;
            }
            case "LivingSpecimen": {
                return BasisOfRecord.LivingSpecimen;
            }
            case "HumanObservation": {
                return BasisOfRecord.HumanObservation;
            }
            case "MachineObservation": {
                return BasisOfRecord.MachineObservation;
            }
            case "Observation": {
                return BasisOfRecord.Observation;
            }
            case "Literature": {
                return BasisOfRecord.Literature;
            }
            case "MaterialSample": {
                return BasisOfRecord.MaterialSample;
            }
        }
        return BasisOfRecord.Unknown;
    }
}

