/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.obisplugin.capabilities;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.gcube.data.spd.model.Condition;
import org.gcube.data.spd.model.Conditions;
import org.gcube.data.spd.model.exceptions.StreamBlockingException;
import org.gcube.data.spd.model.exceptions.StreamException;
import org.gcube.data.spd.model.exceptions.StreamNonBlockingException;
import org.gcube.data.spd.model.products.OccurrencePoint;
import org.gcube.data.spd.obisplugin.search.OccurrenceSearch;
import org.gcube.data.spd.plugin.fwk.capabilities.OccurrencesCapability;
import org.gcube.data.spd.plugin.fwk.writers.ClosableWriter;
import org.gcube.data.spd.plugin.fwk.writers.ObjectWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OccurrencesCapabilityImpl
extends OccurrencesCapability {
    private static Logger logger = LoggerFactory.getLogger(OccurrencesCapabilityImpl.class);
    private String baseUrl;

    public OccurrencesCapabilityImpl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public Set<Conditions> getSupportedProperties() {
        return new HashSet<Conditions>(){
            {
                this.add(Conditions.DATE);
                this.add(Conditions.COORDINATE);
            }
        };
    }

    public void searchByScientificName(String word, ObjectWriter<OccurrencePoint> writer, Condition ... properties) {
        try {
            new OccurrenceSearch(this.baseUrl).search(writer, word, 50, properties);
        }
        catch (Exception e) {
            logger.debug("search occurrences by ScientificName failed", (Throwable)e);
        }
    }

    public void getOccurrencesByProductKeys(ClosableWriter<OccurrencePoint> writer, Iterator<String> keys) {
        OccurrenceSearch occSearch = null;
        try {
            occSearch = new OccurrenceSearch(this.baseUrl);
        }
        catch (Exception e) {
            logger.error("error contacting obis server");
            writer.write((StreamException)new StreamBlockingException("OBIS"));
            return;
        }
        while (keys.hasNext()) {
            String key = keys.next();
            try {
                occSearch.searchByKey((ObjectWriter<OccurrencePoint>)writer, key, 50);
            }
            catch (Exception e) {
                logger.warn("error retrieving key " + key, (Throwable)e);
                writer.write((StreamException)new StreamNonBlockingException("OBIS", key));
            }
        }
        writer.close();
    }

    public void getOccurrencesByIds(ClosableWriter<OccurrencePoint> writer, Iterator<String> ids) {
        OccurrenceSearch occSearch = null;
        try {
            occSearch = new OccurrenceSearch(this.baseUrl);
        }
        catch (Exception e) {
            logger.error("error contacting gbif server");
            writer.write((StreamException)new StreamBlockingException("OBIS"));
            return;
        }
        while (ids.hasNext()) {
            String id = ids.next();
            try {
                if (!writer.isAlive()) {
                    logger.trace("the writer is closed");
                    return;
                }
                writer.write((Object)occSearch.searchById(id));
            }
            catch (Exception e) {
                logger.warn("error retrieving id " + id, (Throwable)e);
                writer.write((StreamException)new StreamNonBlockingException("OBIS", id));
            }
        }
        writer.close();
    }
}

