/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.client.proxies;

import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import org.gcube.common.clients.Call;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.common.clients.stubs.jaxws.JAXWSUtils;
import org.gcube.data.spd.client.proxies.ExecutorClient;
import org.gcube.data.spd.model.service.exceptions.InvalidIdentifierException;
import org.gcube.data.spd.model.service.types.CompleteJobStatus;
import org.gcube.data.spd.model.service.types.JobType;
import org.gcube.data.spd.model.service.types.SubmitJob;
import org.gcube.data.spd.model.util.SerializableList;
import org.gcube.data.streams.Stream;

public class DefaultExecutor
implements ExecutorClient {
    private final ProxyDelegate<WebTarget> delegate;

    public DefaultExecutor(ProxyDelegate<WebTarget> delegate) {
        this.delegate = delegate;
    }

    private Call<WebTarget, String> getCallForJobs(final String input, final JobType job) {
        Call<WebTarget, String> call = new Call<WebTarget, String>(){

            public String call(WebTarget executor) throws Exception {
                SubmitJob jobRequest = new SubmitJob(input, job);
                return (String)executor.path("execute").request().post(Entity.xml((Object)jobRequest), String.class);
            }
        };
        return call;
    }

    @Override
    public String getErrorLink(final String jobId) throws InvalidIdentifierException {
        Call<WebTarget, String> call = new Call<WebTarget, String>(){

            public String call(WebTarget executor) throws Exception {
                return (String)executor.path("error").path(jobId).request().get(String.class);
            }
        };
        try {
            return (String)this.delegate.make((Call)call);
        }
        catch (Exception e) {
            throw new InvalidIdentifierException();
        }
    }

    @Override
    public String getResultLink(final String jobId) throws InvalidIdentifierException {
        Call<WebTarget, String> call = new Call<WebTarget, String>(){

            public String call(WebTarget executor) throws Exception {
                return (String)executor.path("result").path(jobId).request().get(String.class);
            }
        };
        try {
            return (String)this.delegate.make((Call)call);
        }
        catch (Exception e) {
            throw new InvalidIdentifierException();
        }
    }

    @Override
    public CompleteJobStatus getStatus(final String jobId) throws InvalidIdentifierException {
        Call<WebTarget, CompleteJobStatus> call = new Call<WebTarget, CompleteJobStatus>(){

            public CompleteJobStatus call(WebTarget executor) throws Exception {
                return (CompleteJobStatus)executor.path("status").path(jobId).request().get(CompleteJobStatus.class);
            }
        };
        try {
            return (CompleteJobStatus)this.delegate.make((Call)call);
        }
        catch (Exception e) {
            throw new InvalidIdentifierException();
        }
    }

    @Override
    public void removeJob(final String jobId) throws InvalidIdentifierException {
        Call<WebTarget, JAXWSUtils.Empty> call = new Call<WebTarget, JAXWSUtils.Empty>(){

            public JAXWSUtils.Empty call(WebTarget executor) throws Exception {
                executor.path(jobId).request().delete();
                return new JAXWSUtils.Empty();
            }
        };
        try {
            this.delegate.make((Call)call);
        }
        catch (Exception e) {
            throw new InvalidIdentifierException();
        }
    }

    private Boolean sendInputCall(final String jobId, final List<String> input) throws InvalidIdentifierException {
        Call<WebTarget, Boolean> call = new Call<WebTarget, Boolean>(){

            public Boolean call(WebTarget executor) throws Exception {
                return (Boolean)executor.path("input").path(jobId).request().put(Entity.xml((Object)new SerializableList(input)), Boolean.class);
            }
        };
        try {
            return (Boolean)this.delegate.make((Call)call);
        }
        catch (Exception e) {
            throw new InvalidIdentifierException();
        }
    }

    private void sendInput(String jobId, Stream<String> stream) throws Exception {
        int bunch = 30;
        ArrayList<String> collected = new ArrayList<String>(30);
        while (stream.hasNext()) {
            collected.add((String)stream.next());
            if (collected.size() < bunch) continue;
            if (!this.sendInputCall(jobId, collected).booleanValue()) {
                throw new Exception();
            }
            collected.clear();
        }
        if (collected.size() > 0 && !this.sendInputCall(jobId, collected).booleanValue()) {
            throw new Exception();
        }
        this.sendInputCall(jobId, new ArrayList<String>(0));
    }

    @Override
    public String createDwCAByChildren(String taxonKey) throws Exception {
        return (String)this.delegate.make(this.getCallForJobs(taxonKey, JobType.DWCAByChildren));
    }

    @Override
    public String createDwCAByIds(Stream<String> ids) throws Exception {
        String jobId = (String)this.delegate.make(this.getCallForJobs(null, JobType.DWCAById));
        try {
            this.sendInput(jobId, ids);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return jobId;
    }

    @Override
    public String createCSV(Stream<String> ids) throws Exception {
        String jobId = (String)this.delegate.make(this.getCallForJobs(null, JobType.CSV));
        try {
            this.sendInput(jobId, ids);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return jobId;
    }

    @Override
    public String createCSVforOM(Stream<String> ids) throws Exception {
        String jobId = (String)this.delegate.make(this.getCallForJobs(null, JobType.CSVForOM));
        try {
            this.sendInput(jobId, ids);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return jobId;
    }

    @Override
    public String createDarwincoreFromOccurrenceKeys(Stream<String> ids) throws Exception {
        String jobId = (String)this.delegate.make(this.getCallForJobs(null, JobType.DarwinCore));
        try {
            this.sendInput(jobId, ids);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return jobId;
    }
}

