/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.model.products;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.gcube.data.spd.model.CommonName;
import org.gcube.data.spd.model.products.ResultElement;
import org.gcube.data.spd.model.products.TaxonomyInterface;
import org.gcube.data.spd.model.products.TaxonomyStatus;
import org.gcube.data.spd.model.util.ElementProperty;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.NONE)
public class TaxonomyItem
implements ResultElement,
TaxonomyInterface,
Serializable {
    private static final long serialVersionUID = 1L;
    @XmlAttribute(required=true)
    private String id;
    @XmlAttribute(required=true)
    private String rank;
    @XmlAttribute(required=true)
    private String scientificName;
    @XmlAttribute(required=true)
    private String citation;
    @XmlAttribute(required=false)
    public Calendar modified;
    @XmlAttribute(required=true)
    private String author;
    @XmlAttribute(required=true)
    private String credits;
    @XmlAttribute(required=false)
    private String lsid;
    @XmlElement
    private TaxonomyItem parent;
    @XmlElement
    private List<CommonName> commonNames;
    @XmlElement(required=true)
    private TaxonomyStatus status;
    @XmlAttribute
    private String provider;
    @XmlElement(required=true)
    private List<ElementProperty> properties = new ArrayList<ElementProperty>();

    TaxonomyItem() {
    }

    public TaxonomyItem(String id) {
        this.id = id;
        this.commonNames = Collections.emptyList();
    }

    @Override
    public TaxonomyItem getParent() {
        return this.parent;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getRank() {
        return this.rank;
    }

    public void setRank(String rank) {
        this.rank = rank;
    }

    @Override
    public String getScientificName() {
        return this.scientificName;
    }

    public void setScientificName(String scientificName) {
        this.scientificName = scientificName;
    }

    @Override
    public String getCitation() {
        return this.citation;
    }

    public void setCitation(String citation) {
        this.citation = citation;
    }

    public void setParent(TaxonomyItem parent) {
        this.parent = parent;
    }

    public List<CommonName> getCommonNames() {
        return this.commonNames;
    }

    public void setCommonNames(List<CommonName> commonNames) {
        this.commonNames = commonNames;
    }

    public TaxonomyStatus getStatus() {
        return this.status;
    }

    public void setStatus(TaxonomyStatus status) {
        this.status = status;
    }

    @Override
    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public Calendar getModified() {
        return this.modified;
    }

    public void setModified(Calendar modified) {
        this.modified = modified;
    }

    @Override
    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    @Override
    public String getCredits() {
        return this.credits;
    }

    public void setCredits(String credits) {
        this.credits = credits;
    }

    @Override
    public String getLsid() {
        return this.lsid;
    }

    public void setLsid(String lsid) {
        this.lsid = lsid;
    }

    @Override
    public ResultElement.ResultType getType() {
        return ResultElement.ResultType.TAXONOMY;
    }

    public void addProperty(ElementProperty property) {
        this.properties.add(property);
    }

    public void resetProperties() {
        this.properties = new ArrayList<ElementProperty>();
    }

    @Override
    public List<ElementProperty> getProperties() {
        return Collections.unmodifiableList(this.properties);
    }

    public String toString() {
        return "TaxonomyItem [id=" + this.id + ", rank=" + this.rank + ", scientificName=" + this.scientificName + ", citation=" + this.citation + ", modified=" + this.modified + ", parent=" + this.parent + ", commonNames=" + this.commonNames + ", status=" + this.status + ", provider=" + this.provider + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TaxonomyItem other = (TaxonomyItem)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }
}

